% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyclopsModels.R
\name{predictCyclops}
\alias{predictCyclops}
\title{Create predictive probabilities}
\usage{
predictCyclops(plpModel, data, cohort)
}
\arguments{
\item{plpModel}{An object of type \code{predictiveModel} as generated using
\code{\link{fitPlp}}.}

\item{data}{The new plpData containing the covariateData for the new population}

\item{cohort}{The cohort to calculate the prediction for}
}
\value{
The value column in the result data.frame is: logistic: probabilities of the outcome, poisson:
Poisson rate (per day) of the outome, survival: hazard rate (per day) of the outcome.
}
\description{
Create predictive probabilities
}
\details{
Generates predictions for the population specified in plpData given the model.
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
population <- createStudyPopulation(plpData, outcomeId = 3)
data <- splitData(plpData, population)
plpModel <- fitPlp(data$Train, modelSettings = setLassoLogisticRegression(seed = 42),
                   analysisId = "test", analysisPath = NULL)
prediction <- predictCyclops(plpModel, data$Test, data$Test$labels)
# view prediction dataframe
head(prediction)
}
}
