% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C00-weighted-km.R
\name{plot.weightedKM}
\alias{plot.weightedKM}
\title{Plot Method for Weighted Kaplan-Meier Estimates}
\usage{
\method{plot}{weightedKM}(
  x,
  type = "Kaplan-Meier",
  include_CI = TRUE,
  conf_type = "log-log",
  conf_level = 0.95,
  max_time = NULL,
  strata_to_plot = NULL,
  strata_colors = NULL,
  curve_width = 1,
  CI_alpha = 0.3,
  legend_position = "right",
  legend_title = NULL,
  plot_title = NULL,
  xlab = "Time",
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  risk_table = FALSE,
  risk_table_stats = c("n.risk", "n.acc.event"),
  risk_table_height = 0.25,
  risk_table_breaks = NULL,
  risk_table_fontsize = 3.5,
  ...
)
}
\arguments{
\item{x}{An object of class "weightedKM" from \code{weightedKM()}.}

\item{type}{Type of curve to plot: "Kaplan-Meier" (survival probabilities,
default) or "CR" (cumulative risk, aka. cumulative incidence = 1 - survival).}

\item{include_CI}{Logical. Include confidence interval ribbons? Default TRUE.}

\item{conf_type}{Type of confidence interval: "plain", "log", or
"log-log" (default). See Details.}

\item{conf_level}{Confidence level for intervals. Default 0.95.}

\item{max_time}{Maximum time to display on x-axis. Default is maximum observed
event time.}

\item{strata_to_plot}{Character vector of treatment levels to plot. Default
plots all groups.}

\item{strata_colors}{Character vector of colors for each stratum in
\code{strata_to_plot}. Must match length. Default uses ggplot2 colors.}

\item{curve_width}{Line width for survival curves. Default 1.}

\item{CI_alpha}{Transparency level for confidence interval ribbons (0-1).
Default 0.3.}

\item{legend_position}{Position of legend: "right" or "bottom". Default "right".}

\item{legend_title}{Title for legend. Default "Treatment".}

\item{plot_title}{Main plot title. Default depends on \code{type}.}

\item{xlab}{X-axis label. Default "Time".}

\item{ylab}{Y-axis label. Default depends on \code{type}.}

\item{xlim}{Numeric vector of length 2 specifying x-axis limits. Default \code{c(0, max_time)}.}

\item{ylim}{Numeric vector of length 2 specifying y-axis limits. Default \code{c(0, 1)}.}

\item{risk_table}{Logical. Add risk table below the plot? Default FALSE.
Requires \code{cowplot} package if TRUE.}

\item{risk_table_stats}{Character vector specifying statistics to display in risk table.
Options: "n.risk" (number at risk), "n.acc.event" (cumulative events).
Default \code{c("n.risk", "n.acc.event")}.}

\item{risk_table_height}{Numeric. Relative height of risk table (0-1). Default 0.25.}

\item{risk_table_breaks}{Numeric vector of time points for risk table columns.
If NULL (default), automatically determined based on \code{max_time}.}

\item{risk_table_fontsize}{Numeric. Font size for risk table text. Default 3.5.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A ggplot2 object if \code{risk_table = FALSE}, or a combined plot
  (cowplot object) if \code{risk_table = TRUE}.
}
\description{
Plot Method for Weighted Kaplan-Meier Estimates
}
\details{
When \code{type = "CR"}, the function plots \eqn{1 - S(t)} representing the
probability of experiencing the event by time t. Variance is the same as
for survival, but confidence intervals are calculated on the CR scale.
}
