% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U03-weights.R
\name{calculate_overlap_weights}
\alias{calculate_overlap_weights}
\title{Calculate Overlap Weights}
\usage{
calculate_overlap_weights(ps_result, data, treatment_var)
}
\arguments{
\item{ps_result}{A list returned by \code{estimate_ps()}, containing:
\itemize{
  \item ps_matrix: Matrix of propensity scores (n x J) for multiple treatments,
    or NULL for binary treatment
  \item ps: Vector of propensity scores for observed treatment
  \item n_levels: Number of treatment levels
  \item treatment_levels: Vector of treatment level values
}}

\item{data}{A data.frame containing the treatment variable.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}
}
\value{
A numeric vector of overlap weights with length equal to nrow(data).
}
\description{
Calculates overlap weights using the Li & Li (2019) formula for binary or
multiple treatment groups. Overlap weights target the population with the
most equipoise and are bounded between 0 and 1.
}
\details{
For multiple treatments, overlap weights are calculated as:
\deqn{w_j(X_i) = \frac{1/e_j(X_i)}{\sum_{l=1}^{J} 1/e_l(X_i)}}

For binary treatment (J=2), this reduces to:
\deqn{w(X) = 1 - P(Z = observed | X)}
which equals the probability of receiving the opposite treatment.
}
\references{
Li, F., & Li, F. (2019). Propensity score weighting for causal inference with
multiple treatments. \emph{The Annals of Applied Statistics}, 13(4), 2389-2415.
}
\keyword{internal}
