% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pin.R
\name{pin_yz}
\alias{pin_yz}
\title{PIN estimation - initial parameter sets of Yan & Zhang (2012)}
\usage{
pin_yz(data, factorization, ea_correction = FALSE, grid_size = 5,
                                                  verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{factorization}{A character string from
\code{\{"EHO", "LK", "E", "NONE"\}} referring to a given factorization. The
default value is \code{"E"}.}

\item{ea_correction}{A binary variable determining whether the
modifications of the algorithm of \insertCite{Yan2012;textual}{PINstimation}
suggested by \insertCite{ErsanAlici2016;textual}{PINstimation} are
implemented. The default value is \code{FALSE}.}

\item{grid_size}{An integer between \code{1}, and \code{20};
representing the size of the grid. The default value is \code{5}. See
more in details.}

\item{verbose}{A binary variable that determines whether detailed
information about the steps of the estimation of the PIN model is displayed.
No output is produced when \code{verbose} is set to \code{FALSE}. The default
value is \code{TRUE}.}
}
\value{
Returns an object of class \link{estimate.pin-class}
}
\description{
Estimates the Probability of Informed Trading (\code{PIN}) using the
initial parameter sets generated using the grid search algorithm of
Yan and Zhang (2012).
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.

The factorization variable takes one of four values:
\itemize{
\item \code{"EHO"} refers to the factorization in
\insertCite{Easley2010;textual}{PINstimation}
\item \code{"LK"}  refers to the factorization in
\insertCite{WilliamLin2011;textual}{PINstimation}
\item \code{"E"}  refers to the factorization in
\insertCite{Ersan2016;textual}{PINstimation}
\item \code{"NONE"} refers to the original likelihood function - with no
factorization
}

The argument \code{grid_size} determines the size of the grid of the variables:
\code{alpha}, \code{delta}, and \code{eps.b}. If \code{grid_size} is set to a given value \code{m},
the algorithm creates a sequence starting from \code{1/2m}, and ending in
\code{1 - 1/2m}, with a step of \code{1/m}. The default value of \code{5} corresponds
to the size of the grid in \insertCite{Yan2012;textual}{PINstimation}.
In that case, the sequence starts at \code{0.1 = 1/(2 x 5)}, and ends in
\code{0.9 = 1 - 1/(2 x 5)} with a step of \code{0.2 = 1/m}.

The function \code{pin_yz()} implements, by default, the original
\insertCite{Yan2012;textual}{PINstimation} algorithm as the default value of
\code{ea_correction} takes the value \code{FALSE}.
When the value of \code{ea_correction} is set to \code{TRUE}; then, sets
with irrelevant \code{mu} values are excluded, and sets with boundary values are
reintegrated in the initial parameter sets.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Estimate the PIN model using the factorization of Lin and Ke(2011), and
# initial parameter sets generated using the algorithm of Yan & Zhang (2012).
# In contrast to the original algorithm, we set the grid size for the grid
# search algorithm at 3. The original algorithm assumes a grid of size 5.

estimate <- pin_yz(xdata, "LK", grid_size = 3, verbose = FALSE)

# Display the estimated PIN value

show(estimate@pin)

# Display the estimated parameters

show(estimate@parameters)

# Store the initial parameter sets used for MLE in a dataframe variable,
# and display its first five rows

initialsets <- estimate@initialsets
show(head(initialsets, 5))

}
\references{
\insertAllCited
}
