% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarisePerson.R
\name{summarisePerson}
\alias{summarisePerson}
\title{Summarise person table}
\usage{
summarisePerson(cdm)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
Summarise person table
}
\examples{
\donttest{
library(OmopSketch)
library(dplyr, warn.conflicts = FALSE)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summarisePerson(cdm = cdm)

tablePerson(result = result)

cdmDisconnect(cdm = cdm)
}

}
