% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{printReactable}
\alias{printReactable}
\title{prints a reactable in a quarto document}
\usage{
printReactable(
  data,
  columns = NULL,
  groupBy = NULL,
  defaultPageSize = 20,
  highlight = TRUE,
  striped = TRUE,
  searchable = TRUE,
  filterable = TRUE
)
}
\arguments{
\item{data}{The data for the table}

\item{columns}{The formating for the columns}

\item{groupBy}{A column or columns to group the table by}

\item{defaultPageSize}{The number of rows in the table}

\item{highlight}{whether to highlight the row of interest}

\item{striped}{whether the rows change color to give a striped appearance}

\item{searchable}{whether you can search in the table}

\item{filterable}{whether you can filter the table}
}
\value{
Nothing but the html code for the table is printed (to be used in a quarto document)
}
\description{
This function lets you print a reactable in a quarto document
}
\details{
Input the values for reactable::reactable
}
\examples{
printReactable(
data = data.frame(a=1,b=4)
)

}
\seealso{
Other helper: 
\code{\link{addTarColumn}()},
\code{\link{formatBinaryCovariateName}()},
\code{\link{getExampleConnectionDetails}()},
\code{\link{getOutcomeTable}()},
\code{\link{getTargetTable}()},
\code{\link{kableDark}()},
\code{\link{removeSpaces}()}
}
\concept{helper}
