% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getCmDiagnosticsData}
\alias{getCmDiagnosticsData}
\title{Extract the cohort method diagostic results}
\usage{
getCmDiagnosticsData(
  connectionHandler,
  schema,
  cmTablePrefix = "cm_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL,
  comparatorIds = NULL,
  analysisIds = NULL,
  databaseIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cmTablePrefix}{The prefix used for the cohort method results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{comparatorIds}{A vector of integers corresponding to the comparator cohort IDs}

\item{analysisIds}{An optional vector of analysisIds to filter to}

\item{databaseIds}{An optional vector of databaseIds to filter to}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unqiue identifier of the database}
 \item{analysisId the analysis unique identifier}
 \item{description a description of the analysis}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{comparatorName the comparator cohort name}
 \item{comparatorId the comparator cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome cohort unique identifier}
 \item{maxSdm max allowed standardized difference of means when comparing the target to the comparator after PS adjustment for the ballance diagnostic diagnostic to pass.}
 \item{sharedMaxSdm max allowed standardized difference of means when comparing the target to the comparator after PS adjustment for the ballance diagnostic diagnostic to pass.}
 \item{equipoise the bounds on the preference score to determine whether a subject is in equipoise.}
 \item{mdrr the maximum passable minimum detectable relative risk (mdrr) value.  If the mdrr is greater than this the diagnostics will fail.}
 \item{attritionFraction (depreciated) the minmum attrition before the diagnostics fails.}
 \item{ease The expected absolute systematic error (ease) measures residual bias.}
 \item{balanceDiagnostic whether the balance diagnostic passed or failed.}
 \item{sharedBalanceDiagnostic whether the shared balance diagnostic passed or failed.}
 \item{equipoiseDiagnostic whether the equipose diagnostic passed or failed.}
 \item{mdrrDiagnostic whether the mdrr (power) diagnostic passed or failed.}
 \item{attritionDiagnostic (depreciated) whether the attrition diagnostic passed or failed.}
 \item{easeDiagnostic whether the ease diagnostic passed or failed.}
 \item{unblindForEvidenceSynthesis whether the results can be unblinded for the meta analysis.}
 \item{unblind whether the results can be unblinded.}
 \item{summaryValue summary of diagnostics results. FAIL, PASS or number of warnings.}
 }
}
\description{
This function extracts the cohort method diagnostics that examine whether the analyses were sufficiently powered
and checks for different types of bias.
}
\details{
Specify the connectionHandler, the schema and the target/comparator/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cmDiag <- getCmDiagnosticsData(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
