#' Computes the probability density function of a finite mixture of normal
#' distributions at a given point or vector of points.
#' @param x Numeric vector of points at which the density is evaluated.
#' @param mu Numeric vector of component means.
#' @param sigma Numeric vector of component standard deviations.
#' @param pi Numeric vector of mixing proportions. Must have the same length
#'   as \code{mu} and \code{sigma}, and sum to 1.
#' @return
#' A numeric vector containing the values of the mixture density evaluated
#' at \code{x}.
#' @keywords internal
#' @importFrom stats dnorm
dnorm_mixture = function(x, mu, sigma, pi){
  K = length(mu)
  dens = 0
  for(k in 1:K){
    dens = dens + pi[k] * dnorm(x, mean = mu[k], sd = sigma[k])
  }
  return(dens)
}
