% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{TBI_steroids_df}
\alias{TBI_steroids_df}
\title{Corticosteroids in Acute Traumatic Brain Injury}
\format{
A data frame with 17 observations and 5 variables:
\describe{
  \item{study}{Study identifier (character)}
  \item{event.steroid}{Number of deaths in the corticosteroid group (numeric)}
  \item{n.steroid}{Sample size of the corticosteroid group (numeric)}
  \item{event.control}{Number of deaths in the control group (numeric)}
  \item{n.control}{Sample size of the control group (numeric)}
}
}
\source{
Data taken from the ratesci package version 1.0.0
}
\usage{
data(TBI_steroids_df)
}
\description{
This dataset, TBI_steroids_df, is a data frame containing data from a systematic review evaluating the
effects of corticosteroids on mortality in patients with acute traumatic brain injury. The dataset
includes results from randomized controlled trials, including the influential MRC CRASH trial
(Roberts et al. 2001). Variables include study identifiers, numbers of deaths in the corticosteroid and
control groups, and corresponding sample sizes. These data are useful for meta-analytic investigations
of corticosteroid efficacy in traumatic brain injury.
}
\details{
The dataset name has been kept as TBI_steroids_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
