\name{fibers65}
\alias{fibers65}
\title{Strength of 65 Carbon Fibers at 50 mm Gauge Length}

\description{
Tensile strength measurements (in gigapascals, GPa) for 65 carbon fibers tested
under tension at a gauge length of 50 mm. These data were originally reported by
Bader and Priest (1982) in their foundational study on fibre and bundle strength
in hybrid composites.
}

\usage{
fibers65
}

\format{
A numeric vector of length 65 containing tensile strength values (in GPa).
}

\value{
An object of class \code{"numeric"}.

The vector contains 65 observed tensile strength measurements (in gigapascals)
of individual carbon fibers tested at a gauge length of 50 mm. Each element
represents the breaking strength of a single fiber specimen. The dataset is
typically used as input for statistical modeling, reliability analysis, and
lifetime or strength distribution studies in composite materials research.
}

\details{
The fibers were tested at a gauge length of 50 mm to study the variability of
carbon fiber strength under controlled conditions.  
This dataset is frequently used in reliability analysis, composite material
modeling, and strength distribution studies.  
It is one of several datasets originating from the Bader and Priest (1982)
carbon-fiber experiments.
}

\references{
Bader, M. G., & Priest, A. M. (1982). Statistical aspects of fibre and bundle
strength in hybrid composites.  
\emph{Progress in Science and Engineering of Composites}, 1129--1136.
}

\examples{
data(fibers65)

summary(fibers65)

plot(
  fibers65,
  ylab = "Strength (GPa)",
  main = "Carbon Fiber Strength (50 mm Gauge Length)"
)

hist(
  fibers65,
  main = "Histogram of Carbon Fiber Strength",
  xlab = "Strength (GPa)"
)
}

\keyword{datasets}
