% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCoal.R
\name{mergeCoal}
\alias{mergeCoal}
\title{Overwrite values in one data.frame as available in another.}
\usage{
mergeCoal(x, y, by, cols.coal, add.new = TRUE, as.fun)
}
\arguments{
\item{x}{The initial data.frame}

\item{y}{A data.frame to prioritize overc `x`.}

\item{by}{Columns to merge by. A character vector, with names to columns present in both `x` and `y`. At least one of by and cols.merge must be provided.}

\item{cols.coal}{Columns to overwrite values from `y` if
available. cols.coal must be present in y and may be present in x.}

\item{add.new}{If columns in y are ne to x, merge them in? Default is to do
so.}

\item{as.fun}{Pass a function (say tibble::as_tibble) in as.fun to convert
to something else. If data.tables are wanted, use
as.fun="data.table". The default is to return data as a
data.frame. Modify the defaul using `NMdataConf()`.}
}
\description{
Repair data.frame x with values present in data.frame y. Columns to match by
must be provided.
}
\details{
Non-na values in y will be used o overwrite columns in x
    at the rows matched using `by` columns.

Merges must be done using the same "by" columns for all rows. If
rows needs to be merged using varying by columns, the merges must
be done sequentially.

Will try to guess by and cols.coal.
}
\examples{
library(data.table)
x <- data.table(idx=1:3,a=paste0("xa",1:3),b=paste0("xb",1:3))
y <- data.table(idx=1:2,a=c("ya1",NA),b=c(NA,"yb2"))
mergeCoal(x,y,by="idx")
## multiple rows in x matched by one row in y
x <- data.table(idx=1:3,grp=c(1,1,2),a=paste0("xa",1:3),b=paste0("xb",1:3))
y <- data.table(grp=1,a="y1")
mergeCoal(x,y,by="grp")
## new column (c in y, not in x)
x <- data.table(idx=1:3,a=paste0("xa",1:3),b=paste0("xb",1:3))
y <- data.table(idx=1:2,a=c("ya1",NA),b=c(NA,"yb2"),c=1)
mergeCoal(x,y,by="idx")
}
