% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.mean.pool.R
\name{set.mean.pool}
\alias{set.mean.pool}
\title{Set differences between founder pool}
\usage{
set.mean.pool(
  population,
  pool = NULL,
  mean = NULL,
  trait = NULL,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  reference = "pool",
  max.effects = Inf
)
}
\arguments{
\item{population}{Population list}

\item{pool}{Vector with pools considered (default: 1:length(mean))}

\item{mean}{Vector with the target mean for the different pools}

\item{trait}{Which trait to set the new mean for}

\item{gen}{Quick-insert for database (vector of all generations to export) (THIS CAN ONLY BE APPLIED ON FOUNDERS, if empty -> default: 1)}

\item{database}{Groups of individuals to consider for the export (THIS CAN ONLY BE APPLIED ON FOUNDERS)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export) (THIS CAN ONLY BE APPLIED ON FOUNDERS)}

\item{reference}{Target mean is compared again the reference (default: "pool" - average genomic value in the respective pool, alt: "all")}

\item{max.effects}{Maximum number of locations in the genome that will be assigned an effect for pool-based correction}
}
\value{
Class of in gen/database/cohorts selected individuals
}
\description{
Function to scale trait for genetic differences based on founder pools
}
\examples{
population = creating.diploid(nsnp = 100, nindi = 10, n.additive = 100, founder.pool = 1)
population = creating.diploid(population=population, nindi = 10,
  founder.pool = 2)
population = set.mean.pool(population, mean = c(100,110))
}
