% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.sex.R
\name{get.sex}
\alias{get.sex}
\title{Extraction of individual sex}
\usage{
get.sex(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE,
  male.female.coding = F
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names}

\item{male.female.coding}{Set to TRUE to display male/female instead of 1/2}
}
\description{
Function to extract the sex of selected individuals
}
\examples{
data(ex_pop)
get.sex(ex_pop, gen=2)
}
