% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.litter.effect.R
\name{get.litter.effect}
\alias{get.litter.effect}
\title{Export litter effect}
\usage{
get.litter.effect(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}
}
\value{
Litter effects for in gen/database/cohorts selected individuals
}
\description{
Function to export the litter effect of selected individuals
}
\examples{
data(ex_pop)
get.litter.effect(ex_pop, gen=2)
}
