% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.is.last.R
\name{get.is.last}
\alias{get.is.last}
\title{Last copy}
\usage{
get.is.last(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE,
  keep.order = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}

\item{keep.order}{To not change order of individuals when ids are provided (default: FALSE)}
}
\value{
Logical vector
}
\description{
Function to derive if an individual is the last copy of itself in the database (based on position)
}
\examples{
data(ex_pop)
get.is.last(ex_pop, gen=2)
}
