% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix_utils.R
\name{MixInterpolate}
\alias{MixInterpolate}
\title{Interpolate Predictions from a GLMM}
\usage{
MixInterpolate(xplode.obj, n_points = 100)
}
\arguments{
\item{xplode.obj}{an object of class \code{\link{xplode}}.}

\item{n_points}{An integer number. It specifies the number of points to interpolate along the independent variable range. Default is 100.}
}
\value{
A data frame containing the interpolated independent variable, the corresponding predicted values from the fitted GLMM, and columns for the independent factors.
}
\description{
This function generates an interpolated dataset by predicting values across a range of an independent variable for a GLMM.
}
\examples{
mod.simul = lme4::glmer(formula = cbind(Longer, Total - Longer) ~ X + (1 | Subject), 
family = binomial(link = "probit"), data = simul_data)
xplode.mod = xplode(model = mod.simul, name.cont = "X")

longData <- MixInterpolate(xplode.mod)

# use the interpolated dataset to plot model:
library(ggplot2)
ggplot(longData, aes(X, prediction, color = Subject)) +
geom_line() +
geom_point(data = simul_data, aes(X, Longer/Total))

}
\seealso{
\code{\link{xplode}}, \code{\link[stats]{predict}}.
}
