% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{add_new_taxonomy_pq}
\alias{add_new_taxonomy_pq}
\title{Add new taxonomic rank to a phyloseq object.}
\usage{
add_new_taxonomy_pq(
  physeq,
  ref_fasta,
  suffix = NULL,
  method = c("dada2", "sintax", "lca", "idtaxa", "blastn", "dada2_2steps"),
  trainingSet = NULL,
  min_bootstrap = NULL,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{ref_fasta}{(required) A link to a database.
passed on to \code{dada2::assignTaxonomy}.}

\item{suffix}{(character) The suffix to name the new columns.
If set to NULL (the default), the basename of the file reFasta
is used with the name of the method. Set suffix to "" in order
to remove any suffix.}

\item{method}{(required, default "dada2") :
\itemize{
\item "dada2": \code{\link[dada2:assignTaxonomy]{dada2::assignTaxonomy()}}
\item "dada2_2step": \code{\link[=assign_dada2]{assign_dada2()}}
\item "sintax": see \code{\link[=assign_sintax]{assign_sintax()}}
\item "lca": see \code{\link[=assign_vsearch_lca]{assign_vsearch_lca()}}
\item "idtaxa": see \code{\link[=assign_idtaxa]{assign_idtaxa()}}
\item "blastn": see \code{\link[=assign_blastn]{assign_blastn()}}
}}

\item{trainingSet}{see \code{\link[=assign_idtaxa]{assign_idtaxa()}}. Only used if method = "idtaxa".
Note that if trainingSet is not NULL, the ref_fasta is overwrite by the
trainingSet parameter. To customize learning parameters of the idtaxa
algorithm you must use trainingSet computed by the function \code{\link[=learn_idtaxa]{learn_idtaxa()}}.}

\item{min_bootstrap}{(Float [0:1])

Minimum bootstrap value to inform taxonomy. For each bootstrap
below the min_bootstrap value, the taxonomy information is set to NA.

Correspond to parameters :
\itemize{
\item dada2 & dada2_2step: \code{minBoot}, default value = 0.5
\item sintax: \code{min_bootstrap}, default value = 0.5
\item lca: \code{id}, default value = 0.5. Note in that case, the bootstrap value is different.
See the id parameter in \code{\link[=assign_vsearch_lca]{assign_vsearch_lca()}}
\item idtaxa: \code{threshold}, default value = 0.6
\item blastn: This method do not take different bootstrap value. You may use method="vote" with
different \code{vote_algorithm} as well as different filters parameters
(min_id, min_bit_score, min_cover and min_e_value)
}}

\item{...}{Additional arguments passed on to the taxonomic assignation method.}
}
\value{
A new \code{\link[phyloseq]{phyloseq-class}} object with a larger slot tax_table"
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


One of main use of this function is to add taxonomic assignment from
a new database.
}
\examples{
\dontrun{
ref_fasta <- system.file("extdata",
  "mini_UNITE_fungi.fasta.gz",
  package = "MiscMetabar", mustWork = TRUE
)
add_new_taxonomy_pq(data_fungi_mini, ref_fasta, method = "dada2")
add_new_taxonomy_pq(data_fungi_mini, ref_fasta, method = "dada2_2steps")
add_new_taxonomy_pq(data_fungi_mini, ref_fasta, method = "lca")
add_new_taxonomy_pq(data_fungi_mini, ref_fasta, method = "idtaxa")

# blastn doesn't work with fasta.gz format
ref_fasta <- system.file("extdata",
  "100_sp_UNITE_sh_general_release_dynamic_sintax.fasta",
  package = "MiscMetabar", mustWork = TRUE
)

dp <- add_new_taxonomy_pq(data_fungi_mini, ref_fasta,
  method = "blastn", min_id = 80, min_cover = 50, min_bit_score = 20,
  min_e_value = 1e-20
)
dp_tophit <- add_new_taxonomy_pq(data_fungi_mini, ref_fasta,
  method = "blastn", min_id = 80, min_cover = 50, min_bit_score = 20,
  min_e_value = 1e-20, method_algo = "top_hit"
)
}
}
\seealso{
\code{\link[dada2:assignTaxonomy]{dada2::assignTaxonomy()}}, \code{\link[=assign_sintax]{assign_sintax()}}, \code{\link[=assign_vsearch_lca]{assign_vsearch_lca()}}, \code{\link[=assign_sintax]{assign_sintax()}}, \code{\link[=assign_blastn]{assign_blastn()}}, \code{\link[=assign_dada2]{assign_dada2()}}
}
\author{
Adrien Taudière
}
