% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.mle_0.1.1.R
\name{MW.Copula}
\alias{MW.Copula}
\title{Parametric calculation for the Mann-Whitney effect under the parametric copulas}
\usage{
MW.Copula(
t.event, event, group,
copula = c("clayton", "gumbel", "frank", "fgm", "gb"),
copula.param = 1,
s1 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
s2 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
par1 = c(0, 0),
par2 = c(0, 0),
alpha = 0.05,
logit = FALSE
)
}
\arguments{
\item{t.event}{a vector of time-to-event data.}

\item{event}{a vector for event indicator.}

\item{group}{a vector for group indicator.}

\item{copula}{copula family.}

\item{copula.param}{the copula parameter.}

\item{s1}{a parametric survival function for S1. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{s2}{a parametric survival function for S2. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{par1}{initial value(s) for the parameters of S1.}

\item{par2}{initial value(s) for the parameters of S2.}

\item{alpha}{significance level.}

\item{logit}{logical; if TRUE, the estimator and CI is logit-transformed.}
}
\value{
parameter: a vector of MLE.

estimate: the Mann-Whitney effect estimator

SE: the standard error

CI: the 1-alpha\% confidence interval for Mann-Whitney effect

P.value: the P-value for testing the null hypothesis H0: p=1/2.

kendall: Kendall's tau

logit: the estimator and CI are logit-transformed or not.
}
\description{
\code{MW.Copula} provides a parametric estimator and confidence interval for the Mann-Whitney effect under the parametric survival functions and copulas. The result of this function includes results for logit-transformed estimators. See Nakazono, et al. (2025) for details.
}
\examples{
##Mann-Whitney effect under exponential distributions
#set distribution parameter
lambda1 = 1
lambda2 = 2

#generate time to event
u = runif(100)
t.event1 = -log(u) / lambda1
t.event1 = sort(t.event1)

v = runif(100)
t.event2 = -log(v) / lambda2
t.event2 = sort(t.event2)

#censoring indicator
t1c = runif(100, 0, 1.5)
t.event1 = (t1c >= t.event1) * t.event1 + (t1c < t.event1) * t1c
event1 = 1 * (t1c > t.event1)

t2c = runif(100, 0, 0.8)
t.event2 = (t2c >= t.event2) * t.event2 + (t2c < t.event2) * t2c
event2 = 1 * (t2c > t.event2)

t.event = c(t.event1, t.event2)
event = c(event1, event2)

#group indicator
group = rep(c(1, 0), each = 100)

MW.Copula(t.event, event, group,
          copula = "clayton", copula.param = 1,
          s1 = "exponential", s2 = "exponential", par1 = c(0, 0), par2 = c(0, 0), logit = FALSE)


}
\references{
Nakazono, K., Uozumi, R., & Emura, T. (2025). Parametric inference for the Mann-Whitney effect under survival copula models, Statistical Papers, in press.
}
