% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def.R
\name{make_def}
\alias{make_def}
\title{Creates a variable definition in a Makefile}
\usage{
make_def(variable, definition, operator = "=")
}
\arguments{
\item{variable}{\code{[character(1)]}\cr Variable name}

\item{definition}{\code{[character(1)]}\cr Definition for this variable}

\item{operator}{\code{[character(1)]}\cr Which operator to use, default:
\code{=}}
}
\value{
An object of class \code{MakefileR_def}
}
\description{
A variable definition in a \code{Makefile} consists of a variable name
and its defition.  Both are separated by the equality sign \code{=}.
}
\details{
No quoting is applied to the definition by this function.
Currently, both variable and definition are required to be character values
of length one.

Use the
\code{\link[base]{c}} function or the \code{\link[base]{+}} operator
to append definitions to groups and Makefiles.
}
\examples{
make_def("R_USER_LIBRARY", .libPaths()[[1L]])
makefile() +
  make_def("R_USER_LIBRARY", .libPaths()[[1L]])

}
\references{
https://www.gnu.org/software/make/manual/
}
\seealso{
\code{\link{makefile}}, \code{\link{make_group}}

Other items: 
\code{\link{make_comment}()},
\code{\link{make_group}()},
\code{\link{make_rule}()},
\code{\link{make_text}()}
}
\concept{items}
