#' Creates a Makefile
#'
#' A \code{Makefile} consists of a list of rules, definition, comments
#' and other items.
#'
#' Use the
#' \code{\link[base]{c}} function or the \code{\link[base]{+}} operator
#' to append rules, definitions, comments, plain text, and groups.
#'
#' @inheritParams make_group
#' @return An object of class \code{MakefileR_file}
#' @seealso \code{\link{make_rule}}, \code{\link{make_def}},
#'   \code{\link{make_comment}}, \code{\link{make_text}}, \code{\link{make_group}},
#'   \code{\link{c.MakefileR_group}}
#'
#' @examples
#' makefile(make_rule("all", c("first_target", "second_target")))
#'
#' @references https://www.gnu.org/software/make/manual/
#'
#' @importFrom magrittr %>%
#' @export
makefile <- function(..., .dots = NULL) {
  rules <- c(list(make_comment("Generated by MakefileR, do not edit by hand")),
             list(...), .dots)
  make_group(.dots = rules, sep = "") %>%
    prepend_class("MakefileR_file")
}

prepend_class <- function(x, new_class) {
  attr(x, "class") <- c(new_class, attr(x, "class", exact = TRUE))
  x
}
