% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_bigten_d.R
\name{scale_colour_bigten_d}
\alias{scale_colour_bigten_d}
\title{Plotting with Big Ten palettes for colour ggplot2 (British spelling)}
\usage{
scale_colour_bigten_d(palette = "primary", direction = 1, ...)
}
\arguments{
\item{palette}{Type of palette: "primary" or "secondary"}

\item{direction}{Sets order of colors. Default direction is 1. If direction is -1,
palette color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A ggproto object defining a discrete colour scale for use with ggplot2.
}
\description{
Plotting with Big Ten palettes for colour ggplot2 (British spelling)
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, colour = factor(cyl))) +
  geom_point() +
  scale_colour_bigten_d(palette = "primary")
}
