% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMSE.R
\name{Simulate}
\alias{Simulate}
\alias{Project}
\alias{runMSE}
\title{Run a Management Strategy Evaluation}
\usage{
Simulate(OM = MSEtool::testOM, parallel = FALSE, silent = FALSE, nsim = NULL)

Project(
  Hist = NULL,
  MPs = NA,
  parallel = FALSE,
  silent = FALSE,
  extended = FALSE,
  checkMPs = FALSE
)

runMSE(
  OM = MSEtool::testOM,
  MPs = NA,
  Hist = FALSE,
  silent = FALSE,
  parallel = FALSE,
  extended = FALSE,
  checkMPs = FALSE
)
}
\arguments{
\item{OM}{An operating model object (class \linkS4class{OM} or class \code{Hist}). Also works for
\code{MOM} objects, as a wrapper for \code{ProjectMOM}}

\item{parallel}{Logical or a named list. Should MPs be run using parallel processing?
For \code{runMSE}, can also be \code{"sac"} to run the entire MSE in parallel
using the split-apply-combine technique. See Details for more information.}

\item{silent}{Should messages be printed out to the console?}

\item{nsim}{Optional. numeric value to override \code{OM@nsim}.}

\item{Hist}{Should model stop after historical simulations? Returns an object of
class 'Hist' containing all historical data}

\item{MPs}{A vector of methods (character string) of class MP}

\item{extended}{Logical. Return extended projection results?
if TRUE, \code{MSE@Misc$extended} is a named list with extended data
(including historical and projection by area), extended version of \code{MSE@Hist}
is returned, and returns \code{MSE@PPD} with StockPars, FleetPars, and ReferencePoints in \code{MSE@PPD}}

\item{checkMPs}{Logical. Check if the specified MPs exist and can be run on \code{SimulatedData}?}
}
\value{
Functions return objects of class \linkS4class{Hist} or \linkS4class{MSE}
\itemize{
\item Simulate - An object of class \linkS4class{Hist}
\item Project - An object of class \linkS4class{MSE}
\item runMSE - An object of class \linkS4class{MSE} if \code{Hist = TRUE} otherwise a class \linkS4class{Hist} object
}
}
\description{
Functions to run the Management Strategy Evaluation (closed-loop
simulation) for a specified operating model
}
\details{
\subsection{Running MPs in parallel}{

For most MPs, running in parallel can actually lead to an increase in computation time, due to the overhead in sending the
information over to the cores. Consequently, by default the MPs will not be run in parallel if \code{parallel=TRUE}
(although other internal code will be run in parallel mode).

To run MPs in parallel, specify a named list with the name of the MP(s) assigned as TRUE. For example,\verb{parallel=list(AvC=TRUE})
will run the \code{AvC} MP in parallel mode.
}

\subsection{Split-apply-combine MSE in parallel}{

Additional savings in computation time can be achieved by running the entire simulation in batches. Individual simulations of the operating model
are divided into separate cores using \link{SubCpars}, \code{Simulate} and \code{Project} are applied independently for each core via \code{snowfall::sfClusterApplyLB}, and the
output (a list of MSE objects) is stitched back together into a single MSE object using \link{joinMSE}.

The ideal number of cores will be determined based on the number of simulations and available cores.

There are several issues to look out for when using this split-apply-combine technique:

\itemize{
\item Numerical optimization for depletion may fail in individual cores when \code{OM@cpars$qs} is not specified.
\item Length bins should be specified in the operating model in \code{OM@cpars$CAL_bins}. Otherwise, length bins can vary by core and
create problems when combining into a single object.
\item Compared to non-parallel runs, sampled parameters in the operating model will vary despite the same value in \code{OM@seed}.
\item If there is an error in individual cores or while combining the parallel output into a single Hist or MSE object, the list of output (from the cores) will be returned.
}
}
}
\section{Functions}{
\itemize{
\item \code{Simulate()}: Run the Historical Simulations from an object of class \code{OM}

\item \code{Project()}: Run the Forward Projections

\item \code{runMSE()}: Run the Historical Simulations and Forward Projections
from an object of class `OM

}}
