% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMSE_Object.r
\docType{class}
\name{MMSE-class}
\alias{MMSE-class}
\title{Class \code{'MMSE'}}
\description{
A Multi Management Strategy Evaluation object that contains information about
simulation conditions and performance of MPs for a multi-stock, multi-fleet operating model.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the MMSE object. Single value. Character string}

\item{\code{nyears}}{The number of years for the historical simulation. Single value. Positive integer}

\item{\code{proyears}}{The number of years for the projections - closed loop simulations. Single value. Positive integer}

\item{\code{nMPs}}{Number of management procedures simulation tested. Single value. Positive integer.}

\item{\code{MPs}}{The names of the MPs that were tested. Vector of length nMPs. Character strings.}

\item{\code{MPcond}}{The MP condition. Character ('bystock': an MP per stock, 'byfleet' and MP per stock and fleet, 'MMP' an MP for all stocks and fleets)}

\item{\code{MPrefs}}{The names of the MPs applied for each stock (row) and fleet (column). An array.}

\item{\code{nsim}}{Number of simulations. Single value. Positive integer}

\item{\code{nstocks}}{Number of stocks. Single value. Positive integer}

\item{\code{nfleets}}{Number of fleets. Single value. Positive integer}

\item{\code{Snames}}{Names of the stocks}

\item{\code{Fnames}}{Names of the fleets (matrix nstocks x nfleets)}

\item{\code{Stocks}}{The stock operating model objects. List of Stocks}

\item{\code{Fleets}}{The fleet operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{Obss}}{The fleet specific observation error operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{Imps}}{The fleet specific implementation error operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{OM}}{A table of sampled parameters of the operating model. Data frame of nsim rows.}

\item{\code{Obs}}{A table of sampled parameters of the observation model. Data frame of nsim rows.}

\item{\code{SB_SBMSY}}{Simulated spawning biomass relative to SBMSY over the projection. An array with dimensions: nsim, nStocks, nMPs, proyears. Non-negative real numbers}

\item{\code{F_FMSY}}{Simulated fishing mortality rate relative to FMSY over the projection. An array with dimensions: nsim, nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{N}}{Simulated stock numbers over the projection. An array with dimensions: nsim, nStocks, \code{maxage}+1, nMPs, proyears, nareas. Non-negative real numbers}

\item{\code{B}}{Simulated stock biomass over the projection. An array with dimensions: nsim, nStocks, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB}}{Simulated spawning stock biomass over the projection. An array with dimensions: nsim, nStocks, nMPs, proyears. Non-negative real numbers}

\item{\code{VB}}{Simulated vulnerable biomass over the projection. An array with dimensions: nsim, nStocks, nMPs, proyears. Non-negative real numbers}

\item{\code{FM}}{Simulated fishing mortality rate over the projection. An array with dimensions: nsim, nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{SPR}}{A list of SPR values. Currently not used.}

\item{\code{Catch}}{Simulated catches (landings) over the projection. An array with dimensions: nsim,  nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{Removals}}{Simulated removals (landings+discards) over the projection. An array with dimensions: nsim,  nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{Effort}}{Simulated relative fishing effort in the projection years. An array with dimensions: nsim, nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{TAC}}{Simulated Total Allowable Catch (prescribed) over the projection (this is NA for input controls). An array with dimensions: nsim, nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{TAE}}{Simulated Total Allowable Effort (prescribed) over the projection (this is NA for output controls). An array with dimensions: nsim, nStocks, nFleets, nMPs, proyears. Non-negative real numbers}

\item{\code{BioEco}}{A named list of bio-economic output. Not currently used.}

\item{\code{RefPoint}}{Named list of annual MSY reference points MSY, FMSY, and SBMSY.
Array with dimensions: nsim, nstocks, nMPs, nyears+proyears. Will be the same as \code{multiHist@Ref$ByYear} unless selectivity is changed by MP}

\item{\code{multiHist}}{The object of class \code{multiHist} containing information from the spool-up period.}

\item{\code{PPD}}{Posterior predictive data. List of \code{Data} objects at the end of
the projection period (length \code{nMPs})}

\item{\code{Misc}}{Miscellaneous output such as posterior predictive data}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('MMSE', Name, nyears, proyears, nMPs, MPs, nsim, OMtable, Obs,
B_BMSYa, F_FMSYa, Ba, FMa, Ca, OFLa, Effort, PAA, CAA, CAL, CALbins)}
}

\author{
T. Carruthers
}
\keyword{classes}
