% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASAP2OM.R
\name{ASAP2OM}
\alias{ASAP2OM}
\alias{ASAP2Data}
\title{Convert ASAP 3 assessments into an operating model}
\usage{
ASAP2OM(
  asap,
  nsim = 48,
  proyears = 50,
  mcmc = FALSE,
  spawn_time_frac = 0,
  Name = "ASAP Model",
  Source = "No source provided",
  nyr_par_mu = 3,
  Author = "No author provided",
  report = FALSE,
  silent = FALSE
)

ASAP2Data(asap, Name = "ASAP assessment")
}
\arguments{
\item{asap}{A list returned by ASAP, e.g., \code{asap <- dget("asap3.rdat")}.}

\item{nsim}{The number of simulations in the operating model}

\item{proyears}{The number of MSE projection years}

\item{mcmc}{Logical, whether to use mcmc samples. Currently unsupported.}

\item{spawn_time_frac}{Numeric, the fraction of a year when spawning takes place (e.g., 0.5 is the midpoint of the year)}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{nyr_par_mu}{integer, the number of recent years to estimate vulnerability over for future projections}

\item{Author}{Who did the assessment}

\item{report}{Logical, should a comparison of biomass reconstruction be produced?}

\item{silent}{Logical, should progress reporting be printed to the console?}
}
\value{
An operating model \linkS4class{OM} class.
}
\description{
Reads a fitted ASAP model and uses the MLE estimates with identical reconstruction among simulations. Future recruitment is
sampled from a lognormal distribution with autocorrelation. \code{ASAP2Data} imports a Data object.
}
\details{
Length at age is not used in ASAP so arbitrary placeholder values are used for length-based parameters. Update
these parameters to model length in the operating model.
}
\seealso{
\link{Assess2OM}
}
\author{
Q. Huynh
}
