% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_h2_total}
\alias{table_h2_total}
\title{Friedman's H-Statistic Table}
\usage{
table_h2_total(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{A fitted \code{wrap_object} with results from
\code{sensitivity_analysis(methods = "Friedman H-stat")} or compatible
internal computations.}

\item{show_table}{Logical. If TRUE, prints the table (default = FALSE).}
}
\value{
A dataframe containing the global H-statistic for each feature.
}
\description{
The \strong{table_h2_total()} function computes the \strong{global Friedman H-statistic}
for each feature, quantifying how much of a variable's predictive contribution
arises from interactions with other features rather than from its individual
main effect. This metric provides a model-agnostic measure of overall
interaction strength, following the formulation presented in
\emph{Interpretable Machine Learning} by Christoph Molnar.

The resulting table ranks all features by their global H-statistic, helping
identify which predictors participate most in interaction-driven behavior.
}
\examples{
# After running sensitivity_analysis(wrap_object, methods = "Friedman H-stat"):
# table_h2 <- table_h2_total(wrap_object)

}
\references{
Molnar, C. (2022). \emph{Interpretable Machine Learning}.\cr
\url{https://christophm.github.io/interpretable-ml-book/}
}
\seealso{
\code{\link{sensitivity_analysis}}
}
