% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indonesia_literacy_rate.R
\name{get_indonesia_literacy_rate}
\alias{get_indonesia_literacy_rate}
\title{Get Indonesia's Literacy Rate (Age 15+) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SE.ADT.LITR.ZS}
}
\usage{
get_indonesia_literacy_rate()
}
\value{
A tibble with columns:
\itemize{
  \item \code{indicator}: Indicator name.
  \item \code{country}: Country name ("Indonesia").
  \item \code{year}: Year (integer).
  \item \code{value}: Literacy rate (numeric percentage).
}
Returns \code{NULL} if the API is unavailable or returns an error.
}
\description{
Retrieves Indonesia's literacy rate for adults aged 15 and above,
expressed as a percentage, for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SE.ADT.LITR.ZS}.
}
\details{
The function sends a GET request to the World Bank API.
If the request fails (timeout, network error, or invalid HTTP status),
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
\donttest{
get_indonesia_literacy_rate()
}

}
