% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPZone_request.R
\name{HPZone_request_paginated}
\alias{HPZone_request_paginated}
\title{Performs a HPZone request with the given parameters.}
\usage{
HPZone_request_paginated(
  query,
  ...,
  n_max = 500,
  scope = API_env$scope_standard
)
}
\arguments{
\item{query}{A GraphQL query to send to the HPZone API. Note that keywords 'skip' and 'take' cannot be present in the query; this function will add them.}

\item{...}{Parameters to be passed to sprintf(). If empty, the body is not passed through sprintf().}

\item{n_max}{Maximum number of entries to request per call.}

\item{scope}{The desired scope; either standard or extended.}
}
\value{
A data frame containing all the responses gathered from the API. Only the items will be returned.
}
\description{
Convenience wrapper around [HPZone_request_query()]. This function automatically pulls the available number of records, rather than only the first 500.
Note that the current maximum for batching is 500 rows, so increasing n_max is not recommended.
This function is mainly intended for use when the query builder in [HPZone_request()] is insufficient. Usage of [HPZone_request()] is considerably easier otherwise.
}
\examples{
\dontrun{
# Note the single quotes to facilitate double quote encapsulation for arguments.
HPZone_request_paginated(
  paste0('cases(where: {',
      'Case_creation_date: { gte: "2025-01-01" }',
    '}) {',
      'items { Case_creation_date, Case_number }',
     '}'))
# Or equal, making use of the sprintf integration:
startdate = "2025-01-01"
fields = c("Case_creation_date", "Case_number")
HPZone_request_paginated(
  'cases(where: { Case_creation_date: { gte: "\%s" } }) { items { \%s } }',
   startdate, stringr::str_c(fields, collapse=", ")
)
}
}
\seealso{
[HPZone_request()], [HPZone_convert_dates()]
}
