% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shock_cal.R
\name{create_calc_config}
\alias{create_calc_config}
\title{Create Calculation Configuration}
\usage{
create_calc_config(
  column_mapping = NULL,
  timeline = 1,
  exclude_self_trade = FALSE,
  exclusion_values = NULL
)
}
\arguments{
\item{column_mapping}{Optional named vector mapping initial and target columns
(e.g., \code{c(COMM = "COMM", REG = "REG", REG.1 = "REG.1")}).}

\item{timeline}{Numeric or character range defining simulation periods.
\itemize{
\item Example: "1-5" expands to 1:5.
}}

\item{exclude_self_trade}{Logical; if TRUE, removes intra-region records. Default is FALSE.}

\item{exclusion_values}{Optional named list of elements to exclude from calculation.}
}
\value{
A list containing:
\itemize{
\item \code{column_mapping}: variable mapping between datasets
\item \code{timeline}: expanded numeric sequence of simulation periods
\item \code{exclude_self_trade}: logical flag
\item \code{exclusion_values}: exclusion list by dimension
}
}
\description{
Defines calculation settings for generating shock values, including variable mapping,
timeline sequence, and exclusion criteria. Used as input for both
\code{\link{shock_calculate}} and \code{\link{shock_calculate_uniform}}.
}
\details{
\itemize{
\item Controls column alignment between initial and target datasets
\item Supports numeric or range-based timeline definitions (e.g., "1-10")
\item Excludes self-trade or specified region/sector pairs if configured
\item Provides core metadata for shock calculation functions
}
}
\examples{
# Example: Define Calculation Configuration
calc <- create_calc_config(
  column_mapping      = c(COMM = "COMM", REG = "REG", REG.1 = "REG.1"),
  timeline            = "1-5",
  exclude_self_trade  = TRUE
)
}
\seealso{
\code{\link{create_initial_config}}, \code{\link{create_target_config}},
\code{\link{shock_calculate}}, \code{\link{shock_calculate_uniform}}
}
\author{
Pattawee Puangchit
}
