% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPE.R
\name{CP}
\alias{CP}
\title{Circularly Projected Estimation}
\usage{
CP(y, rmax = 8, r0 = NULL, r = NULL, localfactor = FALSE, type = "IC3")
}
\arguments{
\item{y}{A list of the observation data, each element is a data matrix of each group with dimension \eqn{T \times N_m}.}

\item{rmax}{The maximum factor numbers of all groups. Default is 8.}

\item{r0}{The number of global factors. Default is \code{NULL}, the algorithm will automatically estimate the number of global factors.
If you have prior information about the true number of global factors, you can set it manually.}

\item{r}{The number of local factors in each group. Default is \code{NULL}, the algorithm will automatically estimate the number of local factors.
If you have prior information, set it manually as an integer vector of length \eqn{M} (the number of groups).}

\item{localfactor}{Logical. If \code{FALSE} (default), local factors are not estimated. If \code{TRUE}, local factors will be estimated.}

\item{type}{The method used in estimating the local factor numbers in each group after projecting out the global factors. Default is \code{"IC3"}.}
}
\value{
An object of class \code{"GFA"} containing:
\item{r0hat}{The estimated number of global factors.}
\item{rhat}{The estimated number of local factors (if \code{localfactor = TRUE}).}
\item{rho}{The eigenvalues of the circular projection matrix.}
\item{Ghat}{The estimated global factors.}
\item{Fhat}{The estimated local factors (if \code{localfactor = TRUE}).}
\item{loading_G}{A list consisting of the estimated global factor loadings.}
\item{loading_F}{A list consisting of the estimated local factor loadings (if \code{localfactor = TRUE}).}
\item{residual}{A list consisting of the residuals (if \code{localfactor = TRUE}).}
}
\description{
Circularly Projected Estimation for Group Factor Model.
}
\examples{
dat <- GrFA::gendata()
CP(dat$y, rmax = 8, localfactor = TRUE)

}
\references{
Chen, M. (2023). Circularly Projected Common Factors for Grouped Data. Journal of Business & Economic Statistics, 41(2), 636-649.
}
