% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.SimuPheno}
\alias{GRAB.SimuPheno}
\title{Simulate phenotypes from linear predictors}
\usage{
GRAB.SimuPheno(
  eta,
  traitType = "binary",
  control = list(pCase = 0.1, sdError = 1, pEachGroup = c(1, 1, 1), eventRate = 0.1),
  seed = NULL
)
}
\arguments{
\item{eta}{Vector of linear predictors (typically covariates×beta + genotypes×beta).}

\item{traitType}{Type of phenotype: "quantitative", "binary", "ordinal", or "time-to-event".}

\item{control}{List of simulation parameters specific to each trait type:
\describe{
\item{pCase}{Proportion of cases (binary traits).}
\item{sdError}{Error term standard deviation (quantitative traits).}
\item{pEachGroup}{Group proportions (ordinal traits).}
\item{eventRate}{Event rate (time-to-event traits).}
}}

\item{seed}{Random seed for reproducibility (optional).}
}
\value{
Simulated phenotype vector or data frame:
\describe{
\item{quantitative}{Numeric vector of continuous values.}
\item{binary}{Numeric vector of 0/1 values.}
\item{ordinal}{Numeric vector of categorical levels.}
\item{time-to-event}{Data frame with SurvTime and SurvEvent columns.}
}
}
\description{
Generates various types of phenotypes (quantitative, binary, ordinal,
time-to-event) from linear predictors using appropriate link functions.
}
\details{
\strong{Trait Type Details:}
\itemize{
\item \strong{Quantitative}: Y = eta + error, where error ~ N(0, sdError²)
\item \strong{Binary}: Logistic model with specified case proportion
\item \strong{Ordinal}: Proportional odds model with specified group proportions
\item \strong{Time-to-event}: Weibull survival model with specified event rate
}

For more details, see: https://wenjianbi.github.io/grab.github.io/docs/simulation_phenotype.html
}
