\name{g.impute}
\alias{g.impute}
\title{
  Function to identify invalid periods in the meta-data as generated by \link{g.getmeta}
  and to impute these invalid periods with the average of similar timepoints on other
  days of the measurement
}
\description{
  Functions takes the output from \link{g.getmeta} and information about the study
  protocol to label impute invalid time segments in the data.
}
\usage{
  g.impute(M, I, params_cleaning = c(), desiredtz = "", dayborder = 0,
            TimeSegments2Zero = c(), acc.metric = "ENMO", ID, 
            qwindowImp = c(), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{M}{
    output from \link{g.getmeta}
  }
  \item{I}{
    output from \link{g.inspectfile}
  }
  \item{params_cleaning}{
    See \link{g.part1}
  }
  \item{desiredtz}{
    See \link{g.part1}
  }
  \item{dayborder}{
    See \link{g.part1}
  }
  \item{TimeSegments2Zero}{
    Optional data.frame to specify which time segments need to be ignored for the imputation,
    and acceleration metrics to be imputed by zeros. The data.frame is expected
    to contain two columns named windowstart and windowend, with the start- and end
    time of the time segment in POSIXlt class.
  }
  \item{acc.metric}{
    See \link{GGIR}
  }
  \item{ID}{
    ID extracted in g.part2.
  }
  \item{qwindowImp}{
    qwindow object as documented in See \link{GGIR}. If qwindow is based on a diary 
    then the qwindow object is assumed to only include the values for the current
    participant ID. 
  }
  \item{...}{
     Any argument used in the previous version of g.impute, which will now
     be used to overrule the arguments specified with the parameter objects.
  }
}
\value{
  \item{metashort}{imputed short epoch variables}
  \item{rout}{matrix to clarify when data was imputed for each long epoch time window
  and the reason for imputation. Value = 1 indicates imputation. 
  Columns 1 = monitor non wear, column 2 = clipping, column 3 = additional nonwear,
  column 4 = protocol based exclusion and column5 = sum of column 1,2,3 and 4. }
  \item{averageday}{matrix with n columns for n metrics values and m rows for
  m short epoch time windows in an average 24 hours period}
}
\examples{
  \dontrun{
    #inspect file:
    I = g.inspectfile(datafile)
    #autocalibration:
    C = g.calibrate(datafile) 
    #get meta-data:
    M = g.getmeta(datafile)
  }
  data(data.getmeta)
  data(data.inspectfile)
  #impute meta-data:
  IMP = g.impute(M=data.getmeta, I=data.inspectfile)
}
\keyword{internal}
\author{
  Vincent T van Hees <v.vanhees@accelting.com>
}