% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_calibrate.R
\name{calc_autocalparams}
\alias{calc_autocalparams}
\title{Calculate Auto-calibration Parameters}
\usage{
calc_autocalparams(
  binfile,
  binfile_path,
  output_folder,
  sphere_points,
  use_temp = TRUE,
  spherecrit = 0.3,
  maxiter = 500,
  tol = 1e-13
)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}

\item{binfile_path}{Path to the bin file to be processed.}

\item{output_folder}{Path to the folder containing GENEAcore run outputs and Measurement Period Information (MPI) files.}

\item{sphere_points}{List of points that populate a unitary sphere and their
associated temperature in the form (x,y,z,temp).}

\item{use_temp}{Allows auto-calibration to be run with and without
temperature compensation.}

\item{spherecrit}{The minimum required acceleration value for each axis in
both directions for auto-calibration to be reliable.}

\item{maxiter}{The maximum number of sphere fit iterations attempted during
auto-calibration.}

\item{tol}{The limit of incremental sphere fit improvements before
auto-calibration is considered complete.}
}
\value{
List of auto-calibration parameters within the measurement period
information (MPI).
}
\description{
Function to calculate auto-calibration parameters from known
still points from a bin file that create a unitary sphere.
}
\examples{
binfile_path <- system.file("extdata/10Hz_calibration_file_20Nov25.bin", package = "GENEAcore")
output_folder <- tempdir()
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
MPI <- create_MPI(binfile, binfile_path, output_folder)
nonmovement_list <- detect_nonmovement(binfile, binfile_path, output_folder)
MPI <- calc_autocalparams(
  binfile, binfile_path, output_folder,
  nonmovement_list$non_movement$sphere_points
)
}
