#' GCPBayes Package
#'
#' @description
#' Execute a Gibbs sampler to analyze a multivariate Bayesian sparse group selection model, incorporating Dirac, continuous, and hierarchical spike priors to detect pleiotropic effects across multiple traits. This package is tailored for summary statistics comprising estimated regression coefficients and their corresponding covariance matrices.
#'
#' @docType package
#'
#' @keywords CS
#' @keywords DS
#' @keywords HS
#' @keywords summaryCS
#' @keywords summaryDS
#' @keywords summaryHS
#' @keywords MCMCplot
#'
#' @author Taban Baghfalaki \email{t.baghfalaki@gmail.com}, \email{t.baghfalaki@modares.ac.ir}
#'
#' @references
#' \enumerate{
#' \item
#' Baghfalaki, T., Sugier, P. E., Truong, T., Pettitt, A. N., Mengersen, K., & Liquet, B. (2021). Bayesian meta analysis models for cross cancer genomic investigation of pleiotropic effects using group structure. \emph{Statistics in Medicine}, \strong{40}(6), 1498-1518.
#'
#' \item
#' Baghfalaki, T., Sugier, Y. Asgari, P. E., Truong, & Liquet, B. (2023). GCPBayes:  An R Package for Studying Cross-Phenotype Genetic Associations with Group-Level Bayesian Meta-Analysis. \emph{RJournal}, \strong{15}(1), 122-141.
#' }
#' @name GCPBayes
#'
#' @useDynLib GCPBayes, .registration = TRUE
#' @importFrom Rcpp sourceCpp
NULL
