# Function returns correct values

    Code
      set.seed(123456)
      MethodsComparison(trueData = testMatrix1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
              X2         X3         X4         X2         X3         X4 
      -3.2782390 -1.2314088 -0.9270247  1.1606651  3.0059296  3.0823896 
              X1         X3         X4         X1         X3         X4 
      -2.5630808 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              X1         X2         X4         X1         X2         X4 
      -2.5630808 -3.2782390 -0.9270247  1.5656538  1.1606651  3.0823896 
             X1        X2        X3        X1        X2        X3 
      -2.563081 -3.278239 -1.231409  1.565654  1.160665  3.005930 
              X2         X3         X4         X2         X3         X4 
      -3.2782390 -1.2314088 -0.9270247  2.1152384  3.0059296  3.0823896 
              X1         X3         X4         X1         X3         X4 
      -3.6169809 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              X1         X2         X4         X1         X2         X4 
      -3.6169809 -3.2782390 -0.9270247  1.5656538  2.1152384  3.0823896 
             X1        X2        X3        X1        X2        X3 
      -3.616981 -3.278239 -1.231409  1.565654  2.115238  3.005930 
    Condition
      Warning:
      Number of logged events: 2
    Output
      $dimp
      $dimp$nonFNNumbers
             V1      mean        se 
      0.5000000 0.5000000 0.3535534 
      
      $dimp$errorMatrix
                    X1        X2        X3        X4      mean         se
      MAE   0.18895340 0.4161487 1.0819248 0.2911552 0.4945455 0.08130972
      WMAE  0.10466007 0.5465873 2.1085595 1.1294862 0.9723233 0.04297487
      MSE   0.04613674 0.2398175 1.5331922 0.1133974 0.4831360 0.18375748
      WMSE  0.01724138 0.5175504 5.9463028 2.9519432 2.3582595 0.31282839
      NRMSE 0.09410877 0.1990042 0.5645451 0.1464771 0.2510338 0.03323144
      
      $dimp$statisticalMeasures
                                  X1          X2         X3          X4        mean
      TrueMean           -2.07763890  0.01595209  0.6080200 0.119519486 -0.33353683
      ImpMean            -2.08763701 -0.18891272 -0.4739048 0.287009111 -0.61586135
      AbsDiffTrueImpMean  0.18895340  0.39542395  1.0819248 0.291155169  0.48936432
      GenMean            -0.89286341 -0.63303381  0.3093570 0.578825655 -0.15942865
      GenImpMean         -0.89386323 -0.65352029  0.2011645 0.595574617 -0.18766111
      AbsDiffGenImpMean   0.01889534  0.03954240  0.1081925 0.029115517  0.04893643
      TrueSD              0.81895297  1.03640062  0.1903333 0.918826315  0.74112831
      ImpSD               0.67656149  1.32117738  0.5882002 0.889025822  0.86874122
      AbsDiffTrueImpSD    0.14239148  0.28477676  0.3978669 0.029800493  0.21370890
      GenSD               1.23204855  1.22736828  1.0251809 1.020631251  1.12630723
      GenImpSD            1.22076153  1.21126183  1.0687979 1.017201234  1.12950561
      AbsDiffGenImpSD     0.02168303  0.02041292  0.0436170 0.007160484  0.02321836
                                   se
      TrueMean           0.0030453259
      ImpMean            0.1711477088
      AbsDiffTrueImpMean 0.0849733791
      GenMean            0.0000000000
      GenImpMean         0.0168102383
      AbsDiffGenImpMean  0.0084973379
      TrueSD             0.3365551303
      ImpSD              0.3048280191
      AbsDiffTrueImpSD   0.0330376627
      GenSD              0.0000000000
      GenImpSD           0.0008739549
      AbsDiffGenImpSD    0.0112859118
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6541703 0.6541703 0.080001755
      true+res-anti    0.6494139 0.6494139 0.096935249
      imputed+avs-anti 0.4118381 0.4118381 0.025409984
      imputed+ms-anti  0.5028834 0.5028834 0.026114167
      imputed+res-anti 0.5285208 0.5285208 0.008725803
      parts+avs-anti   0.7202214 0.7202214 0.042484096
      parts+ms-anti    0.7678957 0.7678957 0.058257605
      parts+res-anti   0.8075754 0.8075754 0.025127564
      
      $dimp$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.09290533 0.09290533 0.03938212
      AHD        0.49308755 0.49308755 0.11537970
      HSD        0.36011671 0.36011671 0.08845181
      Bertoluzza 0.17387546 0.17387546 0.03348626
      DiffVal    0.15265439 0.15265439 0.03785532
      DiffAmb    0.15518840 0.15518840 0.03964713
      DiffEV     0.12916983 0.12916983 0.02424017
      DiffWidth  0.13297085 0.13297085 0.02692790
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.0000000 1.0000000 0.7071068 
      
      $missForest$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.6994129 0.5731432 0.3949998 0.5757253 0.5608203 0.17977672
      WMAE  0.2814476 0.3896874 0.7412037 1.0059288 0.6045669 0.03338550
      MSE   1.0928973 0.8932772 0.2206958 0.4256336 0.6581260 0.33813938
      WMSE  0.1281518 0.2482592 0.7319729 1.3016734 0.6025143 0.04548573
      NRMSE 0.4030890 0.3119489 0.2257328 0.3252571 0.3165070 0.09441338
      
      $missForest$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.72459803 -0.54310686 0.213020179 0.69524483 -0.33985997
      AbsDiffTrueImpMean  0.69941288  0.55905895 0.394999821 0.57572534  0.55729925
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.85755933 -0.68893970 0.269856968 0.63639819 -0.16006097
      AbsDiffGenImpMean   0.06994129  0.05590589 0.039499982 0.05757253  0.05572992
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.03057068  0.38994919 0.359935719 1.06171644  0.46054301
      AbsDiffTrueImpSD    0.78838229  0.64645143 0.195150063 0.38877806  0.50469046
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.15907741  1.14777197 1.025661574 1.00977911  1.08557252
      AbsDiffGenImpSD     0.09370936  0.07983920 0.002162501 0.01943717  0.04878706
                                  se
      TrueMean           0.003045326
      ImpMean            0.033123631
      AbsDiffTrueImpMean 0.182266496
      GenMean            0.000000000
      GenImpMean         0.003616896
      AbsDiffGenImpMean  0.018226650
      TrueSD             0.336555130
      ImpSD              0.044660879
      AbsDiffTrueImpSD   0.133427972
      GenSD              0.000000000
      GenImpSD           0.033733100
      AbsDiffGenImpSD    0.028973754
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6136112 0.6136112 0.06144716
      true+res-anti    0.6531038 0.6531038 0.10292701
      imputed+avs-anti 0.5309595 0.5309595 0.05882152
      imputed+ms-anti  0.5693479 0.5693479 0.03566293
      imputed+res-anti 0.5823933 0.5823933 0.06307301
      parts+avs-anti   0.6987568 0.6987568 0.02730630
      parts+ms-anti    0.7861197 0.7861197 0.03732557
      parts+res-anti   0.8076612 0.8076612 0.05384341
      
      $missForest$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02961968 0.02961968 0.0002600509
      AHD        0.29031084 0.29031084 0.0339976950
      HSD        0.20680701 0.20680701 0.0291473510
      Bertoluzza 0.11133844 0.11133844 0.0064671254
      DiffVal    0.08412114 0.08412114 0.0116902967
      DiffAmb    0.08412114 0.08412114 0.0116902967
      DiffEV     0.08350383 0.08350383 0.0048503440
      DiffWidth  0.08350383 0.08350383 0.0048503440
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
             V1      mean        se 
      2.5000000 2.5000000 0.3535534 
      
      $miceRanger$errorMatrix
                    X1        X2        X3        X4      mean        se
      MAE   0.59208495 0.8958609 0.6592093 0.6914823 0.7096594 0.1293918
      WMAE  0.20893885 0.7073257 1.2752965 1.7478513 0.9848531 0.1251097
      MSE   0.99305542 1.6957639 0.4496939 0.6712992 0.9524531 0.3901298
      WMSE  0.08854359 0.7011075 2.0377818 4.5763383 1.8509428 0.4892638
      NRMSE 0.35428507 0.4942800 0.3229424 0.4007187 0.3930565 0.0851858
      
      $miceRanger$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209  0.60802000 0.11951949 -0.33353683
      ImpMean            -1.48555395 -0.82874972 -0.05118931 0.73764637 -0.40696165
      AbsDiffTrueImpMean  0.59208495  0.84470180  0.65920931 0.61812688  0.67853074
      GenMean            -0.89286341 -0.63303381  0.30935695 0.57882565 -0.15942865
      GenImpMean         -0.83365492 -0.71750399  0.24343602 0.64063834 -0.16677114
      AbsDiffGenImpMean   0.05920849  0.08447018  0.06592093 0.06181269  0.06785307
      TrueSD              0.81895297  1.03640062  0.19033332 0.91882631  0.74112831
      ImpSD               0.23415813  0.11879643  0.30882033 0.85973710  0.38037800
      AbsDiffTrueImpSD    0.77321052  0.91760420  0.11848702 0.67273337  0.62050877
      GenSD               1.23204855  1.22736828  1.02518086 1.02063125  1.12630723
      GenImpSD            1.14809091  1.14410747  1.02812499 1.00377587  1.08102481
      AbsDiffGenImpSD     0.08395764  0.09620592  0.01146419 0.03674126  0.05709225
                                  se
      TrueMean           0.003045326
      ImpMean            0.051009224
      AbsDiffTrueImpMean 0.107380591
      GenMean            0.000000000
      GenImpMean         0.004796390
      AbsDiffGenImpMean  0.010738059
      TrueSD             0.336555130
      ImpSD              0.082762250
      AbsDiffTrueImpSD   0.273985328
      GenSD              0.000000000
      GenImpSD           0.035443647
      AbsDiffGenImpSD    0.032186948
      
      $miceRanger$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6299862 0.6299862 0.07809508
      true+res-anti    0.5921713 0.5921713 0.06992514
      imputed+avs-anti 0.6696294 0.6696294 0.03923292
      imputed+ms-anti  0.6961469 0.6961469 0.03282228
      imputed+res-anti 0.7114420 0.7114420 0.01868744
      parts+avs-anti   0.7105672 0.7105672 0.01895508
      parts+ms-anti    0.7064986 0.7064986 0.02395688
      parts+res-anti   0.6586111 0.6586111 0.03158767
      
      $miceRanger$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.06182642 0.06182642 0.016186255
      AHD        0.46752573 0.46752573 0.070835451
      HSD        0.34983756 0.34983756 0.051056415
      Bertoluzza 0.15691757 0.15691757 0.026372048
      DiffVal    0.12411137 0.12411137 0.007746193
      DiffAmb    0.12411137 0.12411137 0.007746193
      DiffEV     0.11768817 0.11768817 0.019779036
      DiffWidth  0.11768817 0.11768817 0.019779036
      
      
      $knn
      $knn$nonFNNumbers
        V1 mean   se 
         4    4    0 
      
      $knn$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.9650756 0.9303168 0.5154908 0.5241538 0.7337592 0.16356204
      WMAE  0.4032609 0.8569786 0.9549014 1.1049214 0.8300156 0.01750165
      MSE   1.5707282 1.3332006 0.2915452 0.4576903 0.9132911 0.44339066
      WMSE  0.1896277 0.7724532 1.0482168 1.6283254 0.9096558 0.05379637
      NRMSE 0.5004077 0.4518080 0.2618955 0.3206117 0.3836807 0.09868337
      
      $knn$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.28685943 -0.91436467 0.235803895 0.60253422 -0.34072150
      AbsDiffTrueImpMean  0.79077948  0.93031676 0.372216105 0.48301473  0.64408177
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.81378547 -0.72606548 0.272135340 0.62712713 -0.16014712
      AbsDiffGenImpMean   0.07907795  0.09303168 0.037221611 0.04830147  0.06440818
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.26596948  0.39645586 0.443933870 0.56469059  0.41776245
      AbsDiffTrueImpSD    0.80502187  0.63994476 0.415900891 0.55747685  0.60458609
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.13572885  1.15173969 1.033443440 0.98784112  1.07718827
      AbsDiffGenImpSD     0.09631971  0.09116898 0.008262582 0.03279013  0.05713535
                                  se
      TrueMean           0.003045326
      ImpMean            0.012436762
      AbsDiffTrueImpMean 0.212428728
      GenMean            0.000000000
      GenImpMean         0.001548209
      AbsDiffGenImpMean  0.021242873
      TrueSD             0.336555130
      ImpSD              0.066138942
      AbsDiffTrueImpSD   0.203841335
      GenSD              0.000000000
      GenImpSD           0.037890016
      AbsDiffGenImpSD    0.033736882
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6329395 0.6329395 0.06017458
      true+res-anti    0.6579711 0.6579711 0.06866236
      imputed+avs-anti 0.5200549 0.5200549 0.08178350
      imputed+ms-anti  0.6695824 0.6695824 0.04767143
      imputed+res-anti 0.6497473 0.6497473 0.08785996
      parts+avs-anti   0.6065657 0.6065657 0.06606806
      parts+ms-anti    0.7415960 0.7415960 0.02102750
      parts+res-anti   0.7724444 0.7724444 0.03456966
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.03745723 0.03745723 0.0007599359
      AHD        0.41399774 0.41399774 0.0097821476
      HSD        0.30734695 0.30734695 0.0146368134
      Bertoluzza 0.14220106 0.14220106 0.0064728877
      DiffVal    0.11583238 0.11583238 0.0089403962
      DiffAmb    0.11583238 0.11583238 0.0089403962
      DiffEV     0.10665079 0.10665079 0.0048546658
      DiffWidth  0.10665079 0.10665079 0.0048546658
      
      
      $pmm
      $pmm$nonFNNumbers
             V1      mean        se 
      3.5000000 3.5000000 0.3535534 
      
      $pmm$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.7305861 0.6997546 0.5000590 0.3779288 0.5770821 0.11921801
      WMAE  0.2708112 0.8107517 0.7891993 0.5958288 0.6166477 0.01184411
      MSE   1.4005371 0.5169214 0.3075138 0.2025841 0.6068891 0.27128120
      WMSE  0.1369682 0.7404543 0.7589071 0.3822135 0.5046358 0.01726492
      NRMSE 0.4350075 0.3059975 0.2665625 0.1891681 0.2991839 0.07319794
      
      $pmm$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.119519486 -0.33353683
      ImpMean            -1.62642717 -0.68380251 0.152511128 0.182567211 -0.49378784
      AbsDiffTrueImpMean  0.73058612  0.69975459 0.455508873 0.070955642  0.48920131
      GenMean            -0.89286341 -0.63303381 0.309356951 0.578825655 -0.15942865
      GenImpMean         -0.84774224 -0.70300926 0.263806063 0.585130427 -0.17545375
      AbsDiffGenImpMean   0.07305861  0.06997546 0.045550887 0.007095564  0.04892013
      TrueSD              0.81895297  1.03640062 0.190333318 0.918826315  0.74112831
      ImpSD               0.12324599  0.86132073 0.323547219 0.494044231  0.45053954
      AbsDiffTrueImpSD    0.69570698  0.17507989 0.133213901 0.454652547  0.36466333
      GenSD               1.23204855  1.22736828 1.025180858 1.020631251  1.12630723
      GenImpSD            1.15243667  1.19091304 1.021549710 0.996040083  1.09023487
      AbsDiffGenImpSD     0.09529665  0.05376217 0.005313039 0.024591168  0.04474076
                                  se
      TrueMean           0.003045326
      ImpMean            0.125103441
      AbsDiffTrueImpMean 0.057076879
      GenMean            0.000000000
      GenImpMean         0.012814877
      AbsDiffGenImpMean  0.005707688
      TrueSD             0.336555130
      ImpSD              0.188822903
      AbsDiffTrueImpSD   0.167015462
      GenSD              0.000000000
      GenImpSD           0.028989505
      AbsDiffGenImpSD    0.023454661
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6052687 0.6052687 0.059962228
      true+res-anti    0.6386558 0.6386558 0.080310676
      imputed+avs-anti 0.2765837 0.2765837 0.006456292
      imputed+ms-anti  0.3623514 0.3623514 0.021335416
      imputed+res-anti 0.4059745 0.4059745 0.011800730
      parts+avs-anti   0.4498057 0.4498057 0.035217983
      parts+ms-anti    0.5741661 0.5741661 0.033233607
      parts+res-anti   0.5796422 0.5796422 0.001868311
      
      $pmm$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02431303 0.02431303 0.0001438808
      AHD        0.25860660 0.25860660 0.0121882537
      HSD        0.18808976 0.18808976 0.0153262167
      Bertoluzza 0.09402245 0.09402245 0.0041839508
      DiffVal    0.07893077 0.07893077 0.0046314399
      DiffAmb    0.07893077 0.07893077 0.0046314399
      DiffEV     0.07051684 0.07051684 0.0031379631
      DiffWidth  0.07051684 0.07051684 0.0031379631
      
      
      attr(,"class")
      [1] "metComp"

---

    Code
      set.seed(123456)
      MethodsComparison(trueData = testDF1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
              X2         X3         X4         X2         X3         X4 
      -3.2782390 -1.2314088 -0.9270247  1.1606651  3.0059296  3.0823896 
              X1         X3         X4         X1         X3         X4 
      -2.5630808 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              X1         X2         X4         X1         X2         X4 
      -2.5630808 -3.2782390 -0.9270247  1.5656538  1.1606651  3.0823896 
             X1        X2        X3        X1        X2        X3 
      -2.563081 -3.278239 -1.231409  1.565654  1.160665  3.005930 
              X2         X3         X4         X2         X3         X4 
      -3.2782390 -1.2314088 -0.9270247  2.1152384  3.0059296  3.0823896 
              X1         X3         X4         X1         X3         X4 
      -3.6169809 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              X1         X2         X4         X1         X2         X4 
      -3.6169809 -3.2782390 -0.9270247  1.5656538  2.1152384  3.0823896 
             X1        X2        X3        X1        X2        X3 
      -3.616981 -3.278239 -1.231409  1.565654  2.115238  3.005930 
    Condition
      Warning:
      Number of logged events: 2
    Output
      $dimp
      $dimp$nonFNNumbers
             V1      mean        se 
      0.5000000 0.5000000 0.3535534 
      
      $dimp$errorMatrix
                    X1        X2        X3        X4      mean         se
      MAE   0.18895340 0.4161487 1.0819248 0.2911552 0.4945455 0.08130972
      WMAE  0.10466007 0.5465873 2.1085595 1.1294862 0.9723233 0.04297487
      MSE   0.04613674 0.2398175 1.5331922 0.1133974 0.4831360 0.18375748
      WMSE  0.01724138 0.5175504 5.9463028 2.9519432 2.3582595 0.31282839
      NRMSE 0.09410877 0.1990042 0.5645451 0.1464771 0.2510338 0.03323144
      
      $dimp$statisticalMeasures
                                  X1          X2         X3          X4        mean
      TrueMean           -2.07763890  0.01595209  0.6080200 0.119519486 -0.33353683
      ImpMean            -2.08763701 -0.18891272 -0.4739048 0.287009111 -0.61586135
      AbsDiffTrueImpMean  0.18895340  0.39542395  1.0819248 0.291155169  0.48936432
      GenMean            -0.89286341 -0.63303381  0.3093570 0.578825655 -0.15942865
      GenImpMean         -0.89386323 -0.65352029  0.2011645 0.595574617 -0.18766111
      AbsDiffGenImpMean   0.01889534  0.03954240  0.1081925 0.029115517  0.04893643
      TrueSD              0.81895297  1.03640062  0.1903333 0.918826315  0.74112831
      ImpSD               0.67656149  1.32117738  0.5882002 0.889025822  0.86874122
      AbsDiffTrueImpSD    0.14239148  0.28477676  0.3978669 0.029800493  0.21370890
      GenSD               1.23204855  1.22736828  1.0251809 1.020631251  1.12630723
      GenImpSD            1.22076153  1.21126183  1.0687979 1.017201234  1.12950561
      AbsDiffGenImpSD     0.02168303  0.02041292  0.0436170 0.007160484  0.02321836
                                   se
      TrueMean           0.0030453259
      ImpMean            0.1711477088
      AbsDiffTrueImpMean 0.0849733791
      GenMean            0.0000000000
      GenImpMean         0.0168102383
      AbsDiffGenImpMean  0.0084973379
      TrueSD             0.3365551303
      ImpSD              0.3048280191
      AbsDiffTrueImpSD   0.0330376627
      GenSD              0.0000000000
      GenImpSD           0.0008739549
      AbsDiffGenImpSD    0.0112859118
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6541703 0.6541703 0.080001755
      true+res-anti    0.6494139 0.6494139 0.096935249
      imputed+avs-anti 0.4118381 0.4118381 0.025409984
      imputed+ms-anti  0.5028834 0.5028834 0.026114167
      imputed+res-anti 0.5285208 0.5285208 0.008725803
      parts+avs-anti   0.7202214 0.7202214 0.042484096
      parts+ms-anti    0.7678957 0.7678957 0.058257605
      parts+res-anti   0.8075754 0.8075754 0.025127564
      
      $dimp$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.09290533 0.09290533 0.03938212
      AHD        0.49308755 0.49308755 0.11537970
      HSD        0.36011671 0.36011671 0.08845181
      Bertoluzza 0.17387546 0.17387546 0.03348626
      DiffVal    0.15265439 0.15265439 0.03785532
      DiffAmb    0.15518840 0.15518840 0.03964713
      DiffEV     0.12916983 0.12916983 0.02424017
      DiffWidth  0.13297085 0.13297085 0.02692790
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.0000000 1.0000000 0.7071068 
      
      $missForest$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.6994129 0.5731432 0.3949998 0.5757253 0.5608203 0.17977672
      WMAE  0.2814476 0.3896874 0.7412037 1.0059288 0.6045669 0.03338550
      MSE   1.0928973 0.8932772 0.2206958 0.4256336 0.6581260 0.33813938
      WMSE  0.1281518 0.2482592 0.7319729 1.3016734 0.6025143 0.04548573
      NRMSE 0.4030890 0.3119489 0.2257328 0.3252571 0.3165070 0.09441338
      
      $missForest$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.72459803 -0.54310686 0.213020179 0.69524483 -0.33985997
      AbsDiffTrueImpMean  0.69941288  0.55905895 0.394999821 0.57572534  0.55729925
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.85755933 -0.68893970 0.269856968 0.63639819 -0.16006097
      AbsDiffGenImpMean   0.06994129  0.05590589 0.039499982 0.05757253  0.05572992
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.03057068  0.38994919 0.359935719 1.06171644  0.46054301
      AbsDiffTrueImpSD    0.78838229  0.64645143 0.195150063 0.38877806  0.50469046
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.15907741  1.14777197 1.025661574 1.00977911  1.08557252
      AbsDiffGenImpSD     0.09370936  0.07983920 0.002162501 0.01943717  0.04878706
                                  se
      TrueMean           0.003045326
      ImpMean            0.033123631
      AbsDiffTrueImpMean 0.182266496
      GenMean            0.000000000
      GenImpMean         0.003616896
      AbsDiffGenImpMean  0.018226650
      TrueSD             0.336555130
      ImpSD              0.044660879
      AbsDiffTrueImpSD   0.133427972
      GenSD              0.000000000
      GenImpSD           0.033733100
      AbsDiffGenImpSD    0.028973754
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6136112 0.6136112 0.06144716
      true+res-anti    0.6531038 0.6531038 0.10292701
      imputed+avs-anti 0.5309595 0.5309595 0.05882152
      imputed+ms-anti  0.5693479 0.5693479 0.03566293
      imputed+res-anti 0.5823933 0.5823933 0.06307301
      parts+avs-anti   0.6987568 0.6987568 0.02730630
      parts+ms-anti    0.7861197 0.7861197 0.03732557
      parts+res-anti   0.8076612 0.8076612 0.05384341
      
      $missForest$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02961968 0.02961968 0.0002600509
      AHD        0.29031084 0.29031084 0.0339976950
      HSD        0.20680701 0.20680701 0.0291473510
      Bertoluzza 0.11133844 0.11133844 0.0064671254
      DiffVal    0.08412114 0.08412114 0.0116902967
      DiffAmb    0.08412114 0.08412114 0.0116902967
      DiffEV     0.08350383 0.08350383 0.0048503440
      DiffWidth  0.08350383 0.08350383 0.0048503440
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
             V1      mean        se 
      2.5000000 2.5000000 0.3535534 
      
      $miceRanger$errorMatrix
                    X1        X2        X3        X4      mean        se
      MAE   0.59208495 0.8958609 0.6592093 0.6914823 0.7096594 0.1293918
      WMAE  0.20893885 0.7073257 1.2752965 1.7478513 0.9848531 0.1251097
      MSE   0.99305542 1.6957639 0.4496939 0.6712992 0.9524531 0.3901298
      WMSE  0.08854359 0.7011075 2.0377818 4.5763383 1.8509428 0.4892638
      NRMSE 0.35428507 0.4942800 0.3229424 0.4007187 0.3930565 0.0851858
      
      $miceRanger$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209  0.60802000 0.11951949 -0.33353683
      ImpMean            -1.48555395 -0.82874972 -0.05118931 0.73764637 -0.40696165
      AbsDiffTrueImpMean  0.59208495  0.84470180  0.65920931 0.61812688  0.67853074
      GenMean            -0.89286341 -0.63303381  0.30935695 0.57882565 -0.15942865
      GenImpMean         -0.83365492 -0.71750399  0.24343602 0.64063834 -0.16677114
      AbsDiffGenImpMean   0.05920849  0.08447018  0.06592093 0.06181269  0.06785307
      TrueSD              0.81895297  1.03640062  0.19033332 0.91882631  0.74112831
      ImpSD               0.23415813  0.11879643  0.30882033 0.85973710  0.38037800
      AbsDiffTrueImpSD    0.77321052  0.91760420  0.11848702 0.67273337  0.62050877
      GenSD               1.23204855  1.22736828  1.02518086 1.02063125  1.12630723
      GenImpSD            1.14809091  1.14410747  1.02812499 1.00377587  1.08102481
      AbsDiffGenImpSD     0.08395764  0.09620592  0.01146419 0.03674126  0.05709225
                                  se
      TrueMean           0.003045326
      ImpMean            0.051009224
      AbsDiffTrueImpMean 0.107380591
      GenMean            0.000000000
      GenImpMean         0.004796390
      AbsDiffGenImpMean  0.010738059
      TrueSD             0.336555130
      ImpSD              0.082762250
      AbsDiffTrueImpSD   0.273985328
      GenSD              0.000000000
      GenImpSD           0.035443647
      AbsDiffGenImpSD    0.032186948
      
      $miceRanger$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6299862 0.6299862 0.07809508
      true+res-anti    0.5921713 0.5921713 0.06992514
      imputed+avs-anti 0.6696294 0.6696294 0.03923292
      imputed+ms-anti  0.6961469 0.6961469 0.03282228
      imputed+res-anti 0.7114420 0.7114420 0.01868744
      parts+avs-anti   0.7105672 0.7105672 0.01895508
      parts+ms-anti    0.7064986 0.7064986 0.02395688
      parts+res-anti   0.6586111 0.6586111 0.03158767
      
      $miceRanger$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.06182642 0.06182642 0.016186255
      AHD        0.46752573 0.46752573 0.070835451
      HSD        0.34983756 0.34983756 0.051056415
      Bertoluzza 0.15691757 0.15691757 0.026372048
      DiffVal    0.12411137 0.12411137 0.007746193
      DiffAmb    0.12411137 0.12411137 0.007746193
      DiffEV     0.11768817 0.11768817 0.019779036
      DiffWidth  0.11768817 0.11768817 0.019779036
      
      
      $knn
      $knn$nonFNNumbers
        V1 mean   se 
         4    4    0 
      
      $knn$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.9650756 0.9303168 0.5154908 0.5241538 0.7337592 0.16356204
      WMAE  0.4032609 0.8569786 0.9549014 1.1049214 0.8300156 0.01750165
      MSE   1.5707282 1.3332006 0.2915452 0.4576903 0.9132911 0.44339066
      WMSE  0.1896277 0.7724532 1.0482168 1.6283254 0.9096558 0.05379637
      NRMSE 0.5004077 0.4518080 0.2618955 0.3206117 0.3836807 0.09868337
      
      $knn$statisticalMeasures
                                  X1          X2          X3         X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.28685943 -0.91436467 0.235803895 0.60253422 -0.34072150
      AbsDiffTrueImpMean  0.79077948  0.93031676 0.372216105 0.48301473  0.64408177
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.81378547 -0.72606548 0.272135340 0.62712713 -0.16014712
      AbsDiffGenImpMean   0.07907795  0.09303168 0.037221611 0.04830147  0.06440818
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.26596948  0.39645586 0.443933870 0.56469059  0.41776245
      AbsDiffTrueImpSD    0.80502187  0.63994476 0.415900891 0.55747685  0.60458609
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.13572885  1.15173969 1.033443440 0.98784112  1.07718827
      AbsDiffGenImpSD     0.09631971  0.09116898 0.008262582 0.03279013  0.05713535
                                  se
      TrueMean           0.003045326
      ImpMean            0.012436762
      AbsDiffTrueImpMean 0.212428728
      GenMean            0.000000000
      GenImpMean         0.001548209
      AbsDiffGenImpMean  0.021242873
      TrueSD             0.336555130
      ImpSD              0.066138942
      AbsDiffTrueImpSD   0.203841335
      GenSD              0.000000000
      GenImpSD           0.037890016
      AbsDiffGenImpSD    0.033736882
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6329395 0.6329395 0.06017458
      true+res-anti    0.6579711 0.6579711 0.06866236
      imputed+avs-anti 0.5200549 0.5200549 0.08178350
      imputed+ms-anti  0.6695824 0.6695824 0.04767143
      imputed+res-anti 0.6497473 0.6497473 0.08785996
      parts+avs-anti   0.6065657 0.6065657 0.06606806
      parts+ms-anti    0.7415960 0.7415960 0.02102750
      parts+res-anti   0.7724444 0.7724444 0.03456966
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.03745723 0.03745723 0.0007599359
      AHD        0.41399774 0.41399774 0.0097821476
      HSD        0.30734695 0.30734695 0.0146368134
      Bertoluzza 0.14220106 0.14220106 0.0064728877
      DiffVal    0.11583238 0.11583238 0.0089403962
      DiffAmb    0.11583238 0.11583238 0.0089403962
      DiffEV     0.10665079 0.10665079 0.0048546658
      DiffWidth  0.10665079 0.10665079 0.0048546658
      
      
      $pmm
      $pmm$nonFNNumbers
             V1      mean        se 
      3.5000000 3.5000000 0.3535534 
      
      $pmm$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.7305861 0.6997546 0.5000590 0.3779288 0.5770821 0.11921801
      WMAE  0.2708112 0.8107517 0.7891993 0.5958288 0.6166477 0.01184411
      MSE   1.4005371 0.5169214 0.3075138 0.2025841 0.6068891 0.27128120
      WMSE  0.1369682 0.7404543 0.7589071 0.3822135 0.5046358 0.01726492
      NRMSE 0.4350075 0.3059975 0.2665625 0.1891681 0.2991839 0.07319794
      
      $pmm$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.119519486 -0.33353683
      ImpMean            -1.62642717 -0.68380251 0.152511128 0.182567211 -0.49378784
      AbsDiffTrueImpMean  0.73058612  0.69975459 0.455508873 0.070955642  0.48920131
      GenMean            -0.89286341 -0.63303381 0.309356951 0.578825655 -0.15942865
      GenImpMean         -0.84774224 -0.70300926 0.263806063 0.585130427 -0.17545375
      AbsDiffGenImpMean   0.07305861  0.06997546 0.045550887 0.007095564  0.04892013
      TrueSD              0.81895297  1.03640062 0.190333318 0.918826315  0.74112831
      ImpSD               0.12324599  0.86132073 0.323547219 0.494044231  0.45053954
      AbsDiffTrueImpSD    0.69570698  0.17507989 0.133213901 0.454652547  0.36466333
      GenSD               1.23204855  1.22736828 1.025180858 1.020631251  1.12630723
      GenImpSD            1.15243667  1.19091304 1.021549710 0.996040083  1.09023487
      AbsDiffGenImpSD     0.09529665  0.05376217 0.005313039 0.024591168  0.04474076
                                  se
      TrueMean           0.003045326
      ImpMean            0.125103441
      AbsDiffTrueImpMean 0.057076879
      GenMean            0.000000000
      GenImpMean         0.012814877
      AbsDiffGenImpMean  0.005707688
      TrueSD             0.336555130
      ImpSD              0.188822903
      AbsDiffTrueImpSD   0.167015462
      GenSD              0.000000000
      GenImpSD           0.028989505
      AbsDiffGenImpSD    0.023454661
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6052687 0.6052687 0.059962228
      true+res-anti    0.6386558 0.6386558 0.080310676
      imputed+avs-anti 0.2765837 0.2765837 0.006456292
      imputed+ms-anti  0.3623514 0.3623514 0.021335416
      imputed+res-anti 0.4059745 0.4059745 0.011800730
      parts+avs-anti   0.4498057 0.4498057 0.035217983
      parts+ms-anti    0.5741661 0.5741661 0.033233607
      parts+res-anti   0.5796422 0.5796422 0.001868311
      
      $pmm$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02431303 0.02431303 0.0001438808
      AHD        0.25860660 0.25860660 0.0121882537
      HSD        0.18808976 0.18808976 0.0153262167
      Bertoluzza 0.09402245 0.09402245 0.0041839508
      DiffVal    0.07893077 0.07893077 0.0046314399
      DiffAmb    0.07893077 0.07893077 0.0046314399
      DiffEV     0.07051684 0.07051684 0.0031379631
      DiffWidth  0.07051684 0.07051684 0.0031379631
      
      
      attr(,"class")
      [1] "metComp"

---

    Code
      set.seed(123456)
      MethodsComparison(trueData = testList1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
              V2         V3         V4         V2         V3         V4 
      -3.2782390 -1.2314088 -0.9270247  1.1606651  3.0059296  3.0823896 
              V1         V3         V4         V1         V3         V4 
      -2.5630808 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              V1         V2         V4         V1         V2         V4 
      -2.5630808 -3.2782390 -0.9270247  1.5656538  1.1606651  3.0823896 
             V1        V2        V3        V1        V2        V3 
      -2.563081 -3.278239 -1.231409  1.565654  1.160665  3.005930 
              V2         V3         V4         V2         V3         V4 
      -3.2782390 -1.2314088 -0.9270247  2.1152384  3.0059296  3.0823896 
              V1         V3         V4         V1         V3         V4 
      -3.6169809 -1.2314088 -0.9270247  1.5656538  3.0059296  3.0823896 
              V1         V2         V4         V1         V2         V4 
      -3.6169809 -3.2782390 -0.9270247  1.5656538  2.1152384  3.0823896 
             V1        V2        V3        V1        V2        V3 
      -3.616981 -3.278239 -1.231409  1.565654  2.115238  3.005930 
    Condition
      Warning:
      Number of logged events: 2
    Output
      $dimp
      $dimp$nonFNNumbers
             V1      mean        se 
      0.5000000 0.5000000 0.3535534 
      
      $dimp$errorMatrix
                    V1        V2        V3        V4      mean         se
      MAE   0.18895340 0.4161487 1.0819248 0.2911552 0.4945455 0.08130972
      WMAE  0.10466007 0.5465873 2.1085595 1.1294862 0.9723233 0.04297487
      MSE   0.04613674 0.2398175 1.5331922 0.1133974 0.4831360 0.18375748
      WMSE  0.01724138 0.5175504 5.9463028 2.9519432 2.3582595 0.31282839
      NRMSE 0.09410877 0.1990042 0.5645451 0.1464771 0.2510338 0.03323144
      
      $dimp$statisticalMeasures
                                  V1          V2         V3          V4        mean
      TrueMean           -2.07763890  0.01595209  0.6080200 0.119519486 -0.33353683
      ImpMean            -2.08763701 -0.18891272 -0.4739048 0.287009111 -0.61586135
      AbsDiffTrueImpMean  0.18895340  0.39542395  1.0819248 0.291155169  0.48936432
      GenMean            -0.89286341 -0.63303381  0.3093570 0.578825655 -0.15942865
      GenImpMean         -0.89386323 -0.65352029  0.2011645 0.595574617 -0.18766111
      AbsDiffGenImpMean   0.01889534  0.03954240  0.1081925 0.029115517  0.04893643
      TrueSD              0.81895297  1.03640062  0.1903333 0.918826315  0.74112831
      ImpSD               0.67656149  1.32117738  0.5882002 0.889025822  0.86874122
      AbsDiffTrueImpSD    0.14239148  0.28477676  0.3978669 0.029800493  0.21370890
      GenSD               1.23204855  1.22736828  1.0251809 1.020631251  1.12630723
      GenImpSD            1.22076153  1.21126183  1.0687979 1.017201234  1.12950561
      AbsDiffGenImpSD     0.02168303  0.02041292  0.0436170 0.007160484  0.02321836
                                   se
      TrueMean           0.0030453259
      ImpMean            0.1711477088
      AbsDiffTrueImpMean 0.0849733791
      GenMean            0.0000000000
      GenImpMean         0.0168102383
      AbsDiffGenImpMean  0.0084973379
      TrueSD             0.3365551303
      ImpSD              0.3048280191
      AbsDiffTrueImpSD   0.0330376627
      GenSD              0.0000000000
      GenImpSD           0.0008739549
      AbsDiffGenImpSD    0.0112859118
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6541703 0.6541703 0.080001755
      true+res-anti    0.6494139 0.6494139 0.096935249
      imputed+avs-anti 0.4118381 0.4118381 0.025409984
      imputed+ms-anti  0.5028834 0.5028834 0.026114167
      imputed+res-anti 0.5285208 0.5285208 0.008725803
      parts+avs-anti   0.7202214 0.7202214 0.042484096
      parts+ms-anti    0.7678957 0.7678957 0.058257605
      parts+res-anti   0.8075754 0.8075754 0.025127564
      
      $dimp$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.09290533 0.09290533 0.03938212
      AHD        0.49308755 0.49308755 0.11537970
      HSD        0.36011671 0.36011671 0.08845181
      Bertoluzza 0.17387546 0.17387546 0.03348626
      DiffVal    0.15265439 0.15265439 0.03785532
      DiffAmb    0.15518840 0.15518840 0.03964713
      DiffEV     0.12916983 0.12916983 0.02424017
      DiffWidth  0.13297085 0.13297085 0.02692790
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.0000000 1.0000000 0.7071068 
      
      $missForest$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.6994129 0.5731432 0.3949998 0.5757253 0.5608203 0.17977672
      WMAE  0.2814476 0.3896874 0.7412037 1.0059288 0.6045669 0.03338550
      MSE   1.0928973 0.8932772 0.2206958 0.4256336 0.6581260 0.33813938
      WMSE  0.1281518 0.2482592 0.7319729 1.3016734 0.6025143 0.04548573
      NRMSE 0.4030890 0.3119489 0.2257328 0.3252571 0.3165070 0.09441338
      
      $missForest$statisticalMeasures
                                  V1          V2          V3         V4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.72459803 -0.54310686 0.213020179 0.69524483 -0.33985997
      AbsDiffTrueImpMean  0.69941288  0.55905895 0.394999821 0.57572534  0.55729925
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.85755933 -0.68893970 0.269856968 0.63639819 -0.16006097
      AbsDiffGenImpMean   0.06994129  0.05590589 0.039499982 0.05757253  0.05572992
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.03057068  0.38994919 0.359935719 1.06171644  0.46054301
      AbsDiffTrueImpSD    0.78838229  0.64645143 0.195150063 0.38877806  0.50469046
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.15907741  1.14777197 1.025661574 1.00977911  1.08557252
      AbsDiffGenImpSD     0.09370936  0.07983920 0.002162501 0.01943717  0.04878706
                                  se
      TrueMean           0.003045326
      ImpMean            0.033123631
      AbsDiffTrueImpMean 0.182266496
      GenMean            0.000000000
      GenImpMean         0.003616896
      AbsDiffGenImpMean  0.018226650
      TrueSD             0.336555130
      ImpSD              0.044660879
      AbsDiffTrueImpSD   0.133427972
      GenSD              0.000000000
      GenImpSD           0.033733100
      AbsDiffGenImpSD    0.028973754
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6136112 0.6136112 0.06144716
      true+res-anti    0.6531038 0.6531038 0.10292701
      imputed+avs-anti 0.5309595 0.5309595 0.05882152
      imputed+ms-anti  0.5693479 0.5693479 0.03566293
      imputed+res-anti 0.5823933 0.5823933 0.06307301
      parts+avs-anti   0.6987568 0.6987568 0.02730630
      parts+ms-anti    0.7861197 0.7861197 0.03732557
      parts+res-anti   0.8076612 0.8076612 0.05384341
      
      $missForest$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02961968 0.02961968 0.0002600509
      AHD        0.29031084 0.29031084 0.0339976950
      HSD        0.20680701 0.20680701 0.0291473510
      Bertoluzza 0.11133844 0.11133844 0.0064671254
      DiffVal    0.08412114 0.08412114 0.0116902967
      DiffAmb    0.08412114 0.08412114 0.0116902967
      DiffEV     0.08350383 0.08350383 0.0048503440
      DiffWidth  0.08350383 0.08350383 0.0048503440
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
             V1      mean        se 
      2.5000000 2.5000000 0.3535534 
      
      $miceRanger$errorMatrix
                    V1        V2        V3        V4      mean        se
      MAE   0.59208495 0.8958609 0.6592093 0.6914823 0.7096594 0.1293918
      WMAE  0.20893885 0.7073257 1.2752965 1.7478513 0.9848531 0.1251097
      MSE   0.99305542 1.6957639 0.4496939 0.6712992 0.9524531 0.3901298
      WMSE  0.08854359 0.7011075 2.0377818 4.5763383 1.8509428 0.4892638
      NRMSE 0.35428507 0.4942800 0.3229424 0.4007187 0.3930565 0.0851858
      
      $miceRanger$statisticalMeasures
                                  V1          V2          V3         V4        mean
      TrueMean           -2.07763890  0.01595209  0.60802000 0.11951949 -0.33353683
      ImpMean            -1.48555395 -0.82874972 -0.05118931 0.73764637 -0.40696165
      AbsDiffTrueImpMean  0.59208495  0.84470180  0.65920931 0.61812688  0.67853074
      GenMean            -0.89286341 -0.63303381  0.30935695 0.57882565 -0.15942865
      GenImpMean         -0.83365492 -0.71750399  0.24343602 0.64063834 -0.16677114
      AbsDiffGenImpMean   0.05920849  0.08447018  0.06592093 0.06181269  0.06785307
      TrueSD              0.81895297  1.03640062  0.19033332 0.91882631  0.74112831
      ImpSD               0.23415813  0.11879643  0.30882033 0.85973710  0.38037800
      AbsDiffTrueImpSD    0.77321052  0.91760420  0.11848702 0.67273337  0.62050877
      GenSD               1.23204855  1.22736828  1.02518086 1.02063125  1.12630723
      GenImpSD            1.14809091  1.14410747  1.02812499 1.00377587  1.08102481
      AbsDiffGenImpSD     0.08395764  0.09620592  0.01146419 0.03674126  0.05709225
                                  se
      TrueMean           0.003045326
      ImpMean            0.051009224
      AbsDiffTrueImpMean 0.107380591
      GenMean            0.000000000
      GenImpMean         0.004796390
      AbsDiffGenImpMean  0.010738059
      TrueSD             0.336555130
      ImpSD              0.082762250
      AbsDiffTrueImpSD   0.273985328
      GenSD              0.000000000
      GenImpSD           0.035443647
      AbsDiffGenImpSD    0.032186948
      
      $miceRanger$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6299862 0.6299862 0.07809508
      true+res-anti    0.5921713 0.5921713 0.06992514
      imputed+avs-anti 0.6696294 0.6696294 0.03923292
      imputed+ms-anti  0.6961469 0.6961469 0.03282228
      imputed+res-anti 0.7114420 0.7114420 0.01868744
      parts+avs-anti   0.7105672 0.7105672 0.01895508
      parts+ms-anti    0.7064986 0.7064986 0.02395688
      parts+res-anti   0.6586111 0.6586111 0.03158767
      
      $miceRanger$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.06182642 0.06182642 0.016186255
      AHD        0.46752573 0.46752573 0.070835451
      HSD        0.34983756 0.34983756 0.051056415
      Bertoluzza 0.15691757 0.15691757 0.026372048
      DiffVal    0.12411137 0.12411137 0.007746193
      DiffAmb    0.12411137 0.12411137 0.007746193
      DiffEV     0.11768817 0.11768817 0.019779036
      DiffWidth  0.11768817 0.11768817 0.019779036
      
      
      $knn
      $knn$nonFNNumbers
        V1 mean   se 
         4    4    0 
      
      $knn$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.9650756 0.9303168 0.5154908 0.5241538 0.7337592 0.16356204
      WMAE  0.4032609 0.8569786 0.9549014 1.1049214 0.8300156 0.01750165
      MSE   1.5707282 1.3332006 0.2915452 0.4576903 0.9132911 0.44339066
      WMSE  0.1896277 0.7724532 1.0482168 1.6283254 0.9096558 0.05379637
      NRMSE 0.5004077 0.4518080 0.2618955 0.3206117 0.3836807 0.09868337
      
      $knn$statisticalMeasures
                                  V1          V2          V3         V4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.11951949 -0.33353683
      ImpMean            -1.28685943 -0.91436467 0.235803895 0.60253422 -0.34072150
      AbsDiffTrueImpMean  0.79077948  0.93031676 0.372216105 0.48301473  0.64408177
      GenMean            -0.89286341 -0.63303381 0.309356951 0.57882565 -0.15942865
      GenImpMean         -0.81378547 -0.72606548 0.272135340 0.62712713 -0.16014712
      AbsDiffGenImpMean   0.07907795  0.09303168 0.037221611 0.04830147  0.06440818
      TrueSD              0.81895297  1.03640062 0.190333318 0.91882631  0.74112831
      ImpSD               0.26596948  0.39645586 0.443933870 0.56469059  0.41776245
      AbsDiffTrueImpSD    0.80502187  0.63994476 0.415900891 0.55747685  0.60458609
      GenSD               1.23204855  1.22736828 1.025180858 1.02063125  1.12630723
      GenImpSD            1.13572885  1.15173969 1.033443440 0.98784112  1.07718827
      AbsDiffGenImpSD     0.09631971  0.09116898 0.008262582 0.03279013  0.05713535
                                  se
      TrueMean           0.003045326
      ImpMean            0.012436762
      AbsDiffTrueImpMean 0.212428728
      GenMean            0.000000000
      GenImpMean         0.001548209
      AbsDiffGenImpMean  0.021242873
      TrueSD             0.336555130
      ImpSD              0.066138942
      AbsDiffTrueImpSD   0.203841335
      GenSD              0.000000000
      GenImpSD           0.037890016
      AbsDiffGenImpSD    0.033736882
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.5678495 0.5678495 0.08490670
      true+ms-anti     0.6329395 0.6329395 0.06017458
      true+res-anti    0.6579711 0.6579711 0.06866236
      imputed+avs-anti 0.5200549 0.5200549 0.08178350
      imputed+ms-anti  0.6695824 0.6695824 0.04767143
      imputed+res-anti 0.6497473 0.6497473 0.08785996
      parts+avs-anti   0.6065657 0.6065657 0.06606806
      parts+ms-anti    0.7415960 0.7415960 0.02102750
      parts+res-anti   0.7724444 0.7724444 0.03456966
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.03745723 0.03745723 0.0007599359
      AHD        0.41399774 0.41399774 0.0097821476
      HSD        0.30734695 0.30734695 0.0146368134
      Bertoluzza 0.14220106 0.14220106 0.0064728877
      DiffVal    0.11583238 0.11583238 0.0089403962
      DiffAmb    0.11583238 0.11583238 0.0089403962
      DiffEV     0.10665079 0.10665079 0.0048546658
      DiffWidth  0.10665079 0.10665079 0.0048546658
      
      
      $pmm
      $pmm$nonFNNumbers
             V1      mean        se 
      3.5000000 3.5000000 0.3535534 
      
      $pmm$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.7305861 0.6997546 0.5000590 0.3779288 0.5770821 0.11921801
      WMAE  0.2708112 0.8107517 0.7891993 0.5958288 0.6166477 0.01184411
      MSE   1.4005371 0.5169214 0.3075138 0.2025841 0.6068891 0.27128120
      WMSE  0.1369682 0.7404543 0.7589071 0.3822135 0.5046358 0.01726492
      NRMSE 0.4350075 0.3059975 0.2665625 0.1891681 0.2991839 0.07319794
      
      $pmm$statisticalMeasures
                                  V1          V2          V3          V4        mean
      TrueMean           -2.07763890  0.01595209 0.608020000 0.119519486 -0.33353683
      ImpMean            -1.62642717 -0.68380251 0.152511128 0.182567211 -0.49378784
      AbsDiffTrueImpMean  0.73058612  0.69975459 0.455508873 0.070955642  0.48920131
      GenMean            -0.89286341 -0.63303381 0.309356951 0.578825655 -0.15942865
      GenImpMean         -0.84774224 -0.70300926 0.263806063 0.585130427 -0.17545375
      AbsDiffGenImpMean   0.07305861  0.06997546 0.045550887 0.007095564  0.04892013
      TrueSD              0.81895297  1.03640062 0.190333318 0.918826315  0.74112831
      ImpSD               0.12324599  0.86132073 0.323547219 0.494044231  0.45053954
      AbsDiffTrueImpSD    0.69570698  0.17507989 0.133213901 0.454652547  0.36466333
      GenSD               1.23204855  1.22736828 1.025180858 1.020631251  1.12630723
      GenImpSD            1.15243667  1.19091304 1.021549710 0.996040083  1.09023487
      AbsDiffGenImpSD     0.09529665  0.05376217 0.005313039 0.024591168  0.04474076
                                  se
      TrueMean           0.003045326
      ImpMean            0.125103441
      AbsDiffTrueImpMean 0.057076879
      GenMean            0.000000000
      GenImpMean         0.012814877
      AbsDiffGenImpMean  0.005707688
      TrueSD             0.336555130
      ImpSD              0.188822903
      AbsDiffTrueImpSD   0.167015462
      GenSD              0.000000000
      GenImpSD           0.028989505
      AbsDiffGenImpSD    0.023454661
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.5910693 0.5910693 0.101325589
      true+ms-anti     0.6052687 0.6052687 0.059962228
      true+res-anti    0.6386558 0.6386558 0.080310676
      imputed+avs-anti 0.2765837 0.2765837 0.006456292
      imputed+ms-anti  0.3623514 0.3623514 0.021335416
      imputed+res-anti 0.4059745 0.4059745 0.011800730
      parts+avs-anti   0.4498057 0.4498057 0.035217983
      parts+ms-anti    0.5741661 0.5741661 0.033233607
      parts+res-anti   0.5796422 0.5796422 0.001868311
      
      $pmm$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.02431303 0.02431303 0.0001438808
      AHD        0.25860660 0.25860660 0.0121882537
      HSD        0.18808976 0.18808976 0.0153262167
      Bertoluzza 0.09402245 0.09402245 0.0041839508
      DiffVal    0.07893077 0.07893077 0.0046314399
      DiffAmb    0.07893077 0.07893077 0.0046314399
      DiffEV     0.07051684 0.07051684 0.0031379631
      DiffWidth  0.07051684 0.07051684 0.0031379631
      
      
      attr(,"class")
      [1] "metComp"

