% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{read_rp_xlsx}
\alias{read_rp_xlsx}
\title{Read retention times (RT) measured on a reverse phase (RP) column}
\source{
Measured by the Institute of Functional Genomics at the University of
Regensburg.
}
\usage{
read_rp_xlsx()
}
\value{
A dataframe of 442 metabolites with columns \code{RT}, \code{SMILES} and \code{NAME}.
}
\description{
Reads retention times from a reverse phase liquid chromatography experiment,
performed at 35\eqn{^\circ}C and a flow rate of 0.3 mL/min. The data is also available
as a dataframe in the package; to access it directly, use \link{RP}.
}
\examples{
x <- read_rp_xlsx()
all.equal(x, RP)

}
\seealso{
RP
}
\keyword{dataset}
