% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_fake_with_privacy.R
\name{generate_fake_with_privacy}
\alias{generate_fake_with_privacy}
\title{Generate fake data with privacy controls}
\usage{
generate_fake_with_privacy(
  data,
  n = 30,
  level = c("low", "medium", "high"),
  seed = NULL,
  sensitive = NULL,
  sensitive_detect = TRUE,
  sensitive_strategy = c("fake", "drop"),
  normalize = TRUE,
  sensitive_patterns = NULL,
  sensitive_regex = NULL
)
}
\arguments{
\item{data}{A data.frame (or coercible) to mirror.}

\item{n}{Rows to generate (default same as input if NULL).}

\item{level}{One of "low","medium","high".}

\item{seed}{Optional RNG seed.}

\item{sensitive}{Character vector of original column names to treat as sensitive.}

\item{sensitive_detect}{Logical; auto-detect common sensitive columns by name.}

\item{sensitive_strategy}{One of "fake" or "drop".}

\item{normalize}{Logical; lightly normalize inputs.}

\item{sensitive_patterns}{Optional named list of patterns to treat as sensitive
(e.g., list(id = "...", email = "...", phone = "...")). Overrides defaults.}

\item{sensitive_regex}{Optional fully-combined regex (single string) to detect
sensitive columns by name. If supplied, it is used instead of defaults.}
}
\value{
data.frame with attributes: sensitive_columns, dropped_columns, name_map
}
\description{
Generates a synthetic copy of \code{data}, then optionally detects/handles
sensitive columns by name. Detection uses the ORIGINAL column names and
maps to output via \code{attr(fake, "name_map")} if present.
}
\details{
Generate fake data with privacy controls
}
