% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision_mtpi2.R
\name{get_decision_mtpi2}
\alias{get_decision_mtpi2}
\title{Dosing decision for the mTPI2 design}
\usage{
get_decision_mtpi2(pT,
                          EI,
                          npts)
}
\arguments{
\item{pT}{a numeric value that specifies the target DLT rate (\eqn{p_T}).}

\item{EI}{a vector that specifies the equivalence interval (EI).}

\item{npts}{the number of participants within which dosing decisions are generated.}
}
\value{
\code{get_decision_mtpi2()} returns:

(1) a dataframe containing the decisions (E, S, D or DU) for each combination of y and n (\code{$tab}),

(2) a list (\code{$setup}) containing user input parameters, such as target, EI, npts, etc.
}
\description{
Generate dosing decisions (E, S, D or DU) of the mTPI2 design for user-specified number of participants.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The mTPI2 design divides the probability of DLT into equal-width intervals:
          underdosing, target dosing, and overdosing. Utilizing a  Bayesian model, mTPI-2
          updates the posterior probability estimates of DLTs. If the interval which maximizes
          the posterior probability is among the underdosing intervals, the decision is to
          escalate to the next higher dose; if the interval which maximizes the posterior
          probability is the target dosing interval, the decision is to stay at the current dose;
          if the interval which maximizes the posterior probability is among the overdosing intervals,
          the decision is to to de-escalate to the next lower dose.

          Also, the mTPI2 design includes a dose exclusion rule. Let \eqn{p_T} represents
          the target DLT rate. If \eqn{Pr(p_d > p_T | y_d , n_d ) > 0.95}, dose \eqn{d}
          and those higher than \eqn{d} are removed from the trial since they are deemed
          excessively toxic.
}
\examples{

get_decision_mtpi2(pT = 0.25,
                   EI = c(0.2,0.3),
                   npts = 12)
}
\references{
Guo, W., Liu, S., & Yin, G. (2017). A more efficient Bayesian model for oncology dose-finding
trials with toxicity probability interval. Clinical Trials, 14(1), 16-26.
}
