% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision_boin.R
\name{get_decision_boin}
\alias{get_decision_boin}
\title{Dosing decision for the BOIN design}
\usage{
get_decision_boin(pT,
                         EI,
                         npts)
}
\arguments{
\item{pT}{a numeric value that specifies the target DLT rate (\eqn{p_T}).}

\item{EI}{a vector that specifies the equivalence interval (EI).}

\item{npts}{the number of participants within which dosing decisions are generated.}
}
\value{
\code{get_decision_boin()} returns:

(1) a dataframe containing the decisions (E, S, D or DU) for each combination of y and n (\code{$tab}),

(2) a list (\code{$setup}) containing user input parameters, such as target, EI, npts, etc.
}
\description{
Generate dosing decisions (E, S, D or DU) of the BOIN design for user-specified number of participants.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The BOIN design uses the following decision rules: if
          \eqn{\frac{y_d}{n_d}} is lower than or equal to the escalation boundary,
          the decision is to escalate to the next higher dose; if \eqn{\frac{y_d}{n_d}}
          is higher than the de-escalation boundary, the decision is to the next lower
          dose; otherwise, the decision is to stay at the current dose.

          Also, the BOIN design includes a dose exclusion rule. Let \eqn{p_T} represents
          the target DLT rate. If \eqn{Pr(p_d > p_T | y_d , n_d ) > 0.95}, dose \eqn{d}
          and those higher than \eqn{d} are removed from the trial since they are deemed
          excessively toxic.
}
\examples{

get_decision_boin(pT = 0.25,
                  EI = c(0.15,0.35),
                  npts = 12)
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical Trials, \emph{Journal of the Royal Statistical Society: Series C}, 64, 507-523.
}
