% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_sbx.R
\name{recombination_sbx}
\alias{recombination_sbx}
\title{/sbx recombination for DE}
\usage{
recombination_sbx(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/sbx" (Simulated Binary) recombination for the ExpDE 
framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_sbx()} understands the following field in 
\code{recpars}:
\itemize{
   \item \code{eta} : spread factor.\cr
   Accepts numeric value \code{eta > 0}.
 }
}

\section{References}{

K. Price, R.M. Storn, J.A. Lampinen, "Differential Evolution: A 
Practical Approach to Global Optimization", Springer 2005\cr
F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3) 309-338, 2003.\cr
K. Deb, R.B. Agrawal, "Simulated binary crossover for continuous search 
space", Complex Systems (9):115-148, 1995.
}

