% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_table.R
\name{import_table}
\alias{import_table}
\title{Import \code{EViews} table objects(s) into R, R Markdown or Quarto.}
\usage{
import_table(wf = "", page = "*", table = "*")
}
\arguments{
\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{page}{Object or a character string representing the name of a workfile page to be created}

\item{table}{Name(s) or wildcard expressions for \code{EViews} table object(s) in an \code{EViews} workfile}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} table objects(s) into R, R Markdown or Quarto.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

# To import all table objects across all pages

import_table(wf="exec_commands")

# To import specific table objects, for example for example `OLSTable`

import_table(wf="exec_commands",table="OLStable")

# To import table objects on specific pages

import_table(wf="exec_commands",page="eviewspage")

# To access the table in base R

eviews$eviewspage_olstable

# To get the values above in R Markdown or Quarto

# chunkLabel$eviewspage_olstable

}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
