% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_package.R
\docType{package}
\name{EstemPMM-package}
\alias{EstemPMM}
\alias{EstemPMM-package}
\title{EstemPMM: Polynomial Maximization Method for Robust Regression and Time Series}
\description{
The EstemPMM package provides robust methods for estimating parameters of linear
models and time series models that are robust to non-Gaussian errors.
}
\section{Linear Regression Functions}{


\code{\link{lm_pmm2}} - Fit linear models using PMM2

\code{\link{compare_with_ols}} - Compare PMM2 with OLS
}

\section{Time Series Functions}{


\code{\link{ts_pmm2}} - General function for fitting time series models using PMM2

\code{\link{ar_pmm2}} - Fit AR models

\code{\link{ma_pmm2}} - Fit MA models

\code{\link{arma_pmm2}} - Fit ARMA models

\code{\link{arima_pmm2}} - Fit ARIMA models

\code{\link{compare_ts_methods}} - Compare PMM2 with classical methods
}

\section{Statistical Inference}{


\code{\link{pmm2_inference}} - Bootstrap inference for linear models

\code{\link{ts_pmm2_inference}} - Bootstrap inference for time series models
}

\section{Utilities}{


\code{\link{pmm_skewness}} - Compute skewness

\code{\link{pmm_kurtosis}} - Compute kurtosis

\code{\link{compute_moments}} - Compute moments and cumulants
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/SZabolotnii/EstemPMM}
  \item Report bugs at \url{https://github.com/SZabolotnii/EstemPMM/issues}
}

}
\author{
\strong{Maintainer}: Serhii Zabolotnii \email{zabolotniua@gmail.com} (\href{https://orcid.org/0000-0003-0242-2234}{ORCID})

}
\keyword{internal}
