% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_chisq_test.R
\name{trainer_chisq_test}
\alias{trainer_chisq_test}
\title{Interpret a chi-squared test (chisq.test) with an audience-aware LLM prompt}
\usage{
trainer_chisq_test(
  csq_obj,
  introduction = NULL,
  alpha = 0.05,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{csq_obj}{An htest object returned by stats::chisq.test().}

\item{introduction}{Optional character string giving the study context.}

\item{alpha}{Numeric significance level (default 0.05).}

\item{audience}{One of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a 3-bullet executive summary
regardless of audience depth (uses trainer_core_summary_only_block()).}

\item{llm_model}{Character; model name for the generator (default "llama3").}

\item{generate}{Logical; if TRUE, call the generator and return prompt + response.}
}
\value{
If generate = FALSE, a prompt string. If TRUE, a list with
  prompt, response, and model.
}
\description{
Builds a clear, audience-tailored prompt to interpret base R stats::chisq.test()
results, handling both goodness-of-fit and contingency-table tests.
Aligned with other TraineR trainers: no invented numbers; audience-specific guidance.
}
\examples{
# GOF
set.seed(1); x <- c(18, 22, 20, 25, 15)
csq1 <- chisq.test(x, p = rep(1/5, 5))
cat(trainer_chisq_test(csq1, audience = "beginner"))

# Contingency (independence)
tbl <- matrix(c(12,5,7,9), nrow=2)
csq2 <- chisq.test(tbl)  # Yates for 2x2 by default
cat(trainer_chisq_test(csq2, audience = "applied"))
}
