% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterSource.R
\name{rasterSource}
\alias{rasterSource}
\title{Distribution of emissions by a georeferenced image}
\source{
Example data is from Defense Meteorological Satellite Program (DMSP).
}
\usage{
rasterSource(r, grid, nlevels = "all", conservative = TRUE, verbose = TRUE)
}
\arguments{
\item{r}{input raster object}

\item{grid}{grid object with the grid information}

\item{nlevels}{number of vertical levels off the emission array}

\item{conservative}{TRUE (default) to conserve total mass, FALSE to conserve flux}

\item{verbose}{display additional information}
}
\value{
Returns a matrix
}
\description{
Calculate the spatial distribution by a raster
}
\examples{
grid  <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d01",sep=""))
x     <- raster::raster(paste(system.file("extdata", package = "EmissV"),"/dmsp.tiff",sep=""))
test  <- rasterSource(x, grid)
image(test, axe = FALSE, main = "Spatial distribution by Persistent Nocturnal Lights from DMSP")
}
\seealso{
\code{\link{gridInfo}} and \code{\link{lineSource}}
}
