% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemDiagnostics.R
\name{itemDiagnostics}
\alias{itemDiagnostics}
\title{Diagnostics Analysis for Low Stability Items}
\usage{
itemDiagnostics(data, ...)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis}

\item{...}{Additional arguments to pass on to
\code{\link[EGAnet]{bootEGA}},
\code{\link[EGAnet]{net.loads}}, and
\code{\link[EGAnet]{UVA}}}
}
\value{
Returns a list containing:

\item{diagnostics}{A data frame containing the diagnostics of low item stabilities
(see \code{\link[EGAnet]{itemStability}})}

\item{boot}{Output from \code{\link[EGAnet]{bootEGA}}}

\item{uva}{Output from \code{\link[EGAnet]{UVA}}}

\item{minor}{A list containing suggested items to \code{keep}, \code{remove}, and
a matrix for probable minor dimensions (\code{minor.matrix})}

\item{loadings}{Output from \code{\link[EGAnet]{net.loads}}}

\item{suggested}{Variables that are suggested to be retained to increase item stability}
}
\description{
Computes item diagnostics to determine whether there exist several
potential psychometric issues that affect \code{\link[EGAnet]{itemStability}}.
These issues include local dependence (using \code{\link[EGAnet]{UVA}}),
minor dimensions (using \code{\link[EGAnet]{cosine}} on the stability patterns),
multidimensional items (using \code{\link[EGAnet]{net.loads}}), and
items with low loadings (using \code{\link[EGAnet]{net.loads}})
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Obtain diagnostics
diagnostics <- itemDiagnostics(wmt, ncores = 2)}

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>, Hudson Golino <hfg9s at virginia.edu>, and Luis Eduardo Garrido <garrido.luiseduardo@gmail.com>
}
