% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_perturb_PCA.R
\name{robust_perturb_pca}
\alias{robust_perturb_pca}
\title{Random Perturbation Robust PCA}
\usage{
robust_perturb_pca(data, m, epsilon = 0.001, sigma = 0.01)
}
\arguments{
\item{data}{T x N matrix.}

\item{m}{Components.}

\item{epsilon}{Perturbation scale.}

\item{sigma}{Noise sd.}
}
\value{
List with Ap, Dp, lambda.
}
\description{
Robust PCA by adding random symmetric perturbation to covariance matrix.
}
\examples{
\dontrun{
set.seed(456)
N <- 80; T <- 100; m.true <- 2
X <- matrix(rnorm(T * N), T, N)
rpca.out <- EFM::robust_perturb_pca(X, m = m.true)
print(round(rpca.out$Ap[1:5, 1:2], 3))
}
}
