% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_unit.r
\name{process_ecotox_units}
\alias{process_ecotox_units}
\title{Process ECOTOX search results by converting \code{character} to units where relevant}
\usage{
process_ecotox_units(x, .fns = as_unit_ecotox, ..., .names = NULL)
}
\arguments{
\item{x}{A \code{data.frame} obtained with \code{search_ecotox()}, for which the units need
to be processed.}

\item{.fns}{Function to convert \code{character} to unit. By default \code{as_unit_ecotox()}
is used which also sanitises the input. You can also write a custom function.}

\item{...}{Arguments passed to \code{.fns}.}

\item{.names}{A 'glue' specification used to rename the unit columns. By default
it is \code{"{.col}"}, which will overwrite existing text columns with unit columns.
You can for instance add a suffix with \code{"{.col}_unit"} if you want to
rename the resulting unit columns.}
}
\value{
Returns a \code{data.frame} in which the columns containing unit information
is converted from the character format from the database to actual unit objects (
\code{?units::units}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The function \code{search_ecotox()} returns fields
from the ECOTOX database as is. Fields that represent units are not standardised in
the database. Therefore, this format is not consistently used throughout the
database. \code{process_ecotox_units()} takes a \code{data.frame} returned by
\code{search_ecotox()}, locates unit columns, represented by text, sanitises the text
and converts them to \code{units::mixed_units()} objects. It will sanitise the unit fields as
much as possible. Units that could not be interpreted are returned as arbitrary \code{unit}.
}
\examples{
if (check_ecotox_availability()) {
  df <- search_ecotox(
    list(
      latin_name    = list(
        terms          = c("Skeletonema", "Daphnia"),
        method         = "contains"
      ),
      chemical_name = list(
        terms          = "benzene",
        method         = "exact"
      )
    ), list_ecotox_fields("full"))

  df_unit <-
    process_ecotox_units(df, warn = FALSE)
}
}
\seealso{
Other ecotox-sanitisers: 
\code{\link{as_date_ecotox}()},
\code{\link{as_numeric_ecotox}()},
\code{\link{as_unit_ecotox}()},
\code{\link{mixed_to_single_unit}()},
\code{\link{process_ecotox_dates}()},
\code{\link{process_ecotox_numerics}()}
}
\author{
Pepijn de Vries
}
\concept{ecotox-sanitisers}
