% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.extract.R
\name{plot.extract}
\alias{plot.extract}
\title{Plot Method for the extract Function.}
\arguments{
\item{x}{An object of class "extract", typically a result of the `extract()` function.}

\item{...}{Additional graphical parameters to be passed to the plot function.}
}
\value{
A ggplot of the latent variable estimate(s) over time.
}
\description{
This function generates a line plot of the latent variable estimates obtained from the `extract()` function. It can handle both one-dimensional and two-dimensional latent variable estimates.
}
\examples{
data(jennings)
dr_out <- extract(varname = jennings$variable, 
                  date = jennings$date, 
                  index = jennings$value, 
                  ncases = jennings$n, 
                  begindt = min(jennings$date), 
                  enddt = max(jennings$date), 
                  npass=1)
plot(dr_out)
}
