% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugReposition.R
\name{DrugReposition}
\alias{DrugReposition}
\title{DrugReposition}
\usage{
DrugReposition(DE,nperm = 2,r = 0.9,p = 10^-10)
}
\arguments{
\item{DE}{A matrix with one column of zscore.}

\item{nperm}{Number of random permutations (default: 2).}

\item{r}{Restart the probability of the random-walk algorithm (default: 0.9).}

\item{p}{For each node, if the difference in centrality score between iterations changes less than this value, the algorithm considers the calculation complete (default: 10^-10).}
}
\value{
A dataframe with seven columns those are drugbankid, centralscore, p.value,fdr,number of targets, drug targets,drugname.
}
\description{
The function "DrugReposition" is used in drug repositioning by calculating the eigenvector centrality of drugs.
}
\examples{
library("igraph")
# Obtain the example data
GEP<-Gettest("GEP")
label<-Gettest("label")
# Run the function
DEscore<-CalDEscore(GEP,label)
# Run the function
\donttest{drug_centrality<-DrugReposition(DE=DEscore,nperm = 2,r = 0.9,p = 10^-10)}
}
