% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{combined_graphs_example}
\alias{combined_graphs_example}
\title{Combined graphs}
\format{
A named list with 2 items.
\describe{
  \item{graphs}{A named list with two groups.}
  \describe{
    \item{groupA}{Graph associated with `groupA`}
    \item{groupB}{Graph associated with `groupB`}
    }
  \item{annotations}{A dataframe of mappings of assigned node IDs to the
  user-provided component identifiers for all nodes in `groupA` and `groupB` together
  and all layers}
  \describe{
  \item{both}{Dataframe}
  }
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and
Targeted Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
combined_graphs_example
}
\description{
Exemplary intermediate pipeline output: Combined graphs example data built by
\code{\link[DrDimont]{generate_combined_graphs}}. Combined graphs were built
using the \link[DrDimont]{individual_graphs_example} and:
}
\details{
\code{inter_layer_connections = list(
         make_connection(from='mrna', to='protein', connect_on='gene_name', weight=1),
         make_connection(from='protein', to='phosphosite', connect_on='gene_name', weight=1),
         make_connection(from='protein', to='metabolite', connect_on=metabolite_protein_interactions, weight='combined_score'))}

A subset of the original data by Krug et al. (2020) and randomly sampled metabolite
data from \code{\link[DrDimont]{layers_example}} was used to generate the correlation
matrices, individual graphs, and combined graphs. They were created from data
stratified by estrogen receptor (ER) status: `groupA` contains data of ER+
patients and `groupB` of ER- patients.
}
\keyword{datasets}
