% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNull.R
\name{findNull}
\alias{findNull}
\title{Find DiNAMIC's null distribution}
\usage{
findNull(x, num.perms, random.seed = NULL)
}
\arguments{
\item{x}{An n by m numeric matrix containing DNA copy number data from n subjects at m markers.}

\item{num.perms}{A positive integer that represents the number of cyclic shifts used to create
the empirical distribution.}

\item{random.seed}{An optional random seed (default = NULL).}
}
\value{
A numerical vector of length num.perms
}
\description{
Find DiNAMIC's null distribution
}
\details{
The cyclic shift procedure is detailed in Bioinformatics (2011) 27(5) 678 - 685.  Briefly,
cyclic shift is a permutation procedure for DNA copy number data that largely preserves the underlying
correlation of the markers.  This function uses \code{num.perms} cyclic shifts of the copy number matrix
\code{x} to create an approximate null distribution for \code{max(colSums(x))} or \code{min(colSums(x))}.
The statistical significance of the observed value of \code{max(colSums(x))} or \code{min(colSums(x))}
is assessed by the functions \code{\link[dinamic]{quickLook}} and \code{\link[dinamic]{detailedLook}}.
}
\examples{
random.seed = 12345
set.seed(random.seed)
x = matrix(rnorm(50), 5, 10)
num.perms = 10
findNull(x, num.perms, random.seed)

}
